/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.exception;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Set;

public class ObjectFieldSettingValueException
extends PortalException {
    private ObjectFieldSettingValueException(String msg) {
        super(msg);
    }

    private ObjectFieldSettingValueException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public static class MustBeLessThan256Characters
    extends ObjectFieldSettingValueException {
        public MustBeLessThan256Characters() {
            super("Storage folder path must be less than 256 characters");
        }
    }

    public static class MissingRequiredValues
    extends ObjectFieldSettingValueException {
        public MissingRequiredValues(String objectFieldName, Set<String> objectFieldSettingsNames) {
            super(String.format("The settings %s are required for object field %s", StringUtil.merge(objectFieldSettingsNames, (String)", "), objectFieldName));
        }
    }

    public static class InvalidValue
    extends ObjectFieldSettingValueException {
        public InvalidValue(String objectFieldName, String objectFieldSettingName, String objectFieldSettingValue) {
            super(String.format("The value %s of setting %s is invalid for object field %s", objectFieldSettingValue, objectFieldSettingName, objectFieldName));
        }

        public InvalidValue(String objectFieldName, String objectFieldSettingName, String objectFieldSettingValue, Throwable throwable) {
            super(String.format("The value %s of setting %s is invalid for object field %s", objectFieldSettingValue, objectFieldSettingName, objectFieldName), throwable);
        }
    }
}

