/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.field.filter.parser;

import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.list.type.model.ListTypeDefinition;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.field.filter.parser.BaseObjectFieldFilterStrategy;
import com.liferay.object.field.frontend.data.set.filter.ListTypeEntryAutocompleteFDSFilter;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PicklistObjectFieldFilterStrategy
extends BaseObjectFieldFilterStrategy {
    private final long _listTypeDefinitionId;
    private final ListTypeDefinitionLocalService _listTypeDefinitionLocalService;
    private final ListTypeEntryLocalService _listTypeEntryLocalService;
    private final ObjectField _objectField;

    public PicklistObjectFieldFilterStrategy(Locale locale, long listTypeDefinitionId, ListTypeDefinitionLocalService listTypeDefinitionLocalService, ListTypeEntryLocalService listTypeEntryLocalService, ObjectField objectField, ObjectViewFilterColumn objectViewFilterColumn) {
        super(locale, objectViewFilterColumn);
        this._listTypeDefinitionId = listTypeDefinitionId;
        this._listTypeDefinitionLocalService = listTypeDefinitionLocalService;
        this._listTypeEntryLocalService = listTypeEntryLocalService;
        this._objectField = objectField;
    }

    @Override
    public FDSFilter getFDSFilter() throws PortalException {
        ListTypeDefinition listTypeDefinition = this._listTypeDefinitionLocalService.getListTypeDefinition(this._objectField.getListTypeDefinitionId());
        return new ListTypeEntryAutocompleteFDSFilter(StringUtil.equals((String)this._objectField.getBusinessType(), (String)"MultiselectPicklist"), this._objectField.getName(), listTypeDefinition.getName(this.locale), this._objectField.getListTypeDefinitionId(), this.parse());
    }

    @Override
    public List<Map<String, String>> getItemsValues() throws JSONException {
        ArrayList<Map<String, String>> itemsValues = new ArrayList<Map<String, String>>();
        JSONArray jsonArray = this.getJSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(this._listTypeDefinitionId, jsonArray.getString(i));
            itemsValues.add(HashMapBuilder.put((Object)"label", (Object)listTypeEntry.getName(this.locale)).put((Object)"value", (Object)jsonArray.getString(i)).build());
        }
        return itemsValues;
    }

    @Override
    public String toValueSummary() throws PortalException {
        return StringUtil.merge((Collection)ListUtil.toList((List)this.getItemsValues(), itemValue -> (String)itemValue.get("label")), (String)", ");
    }
}

