/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.entry.permission.util;

import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;

public class ObjectEntryPermissionUtil {
    public static void checkAccountEntryPermission(AccountEntryLocalService accountEntryLocalService, String actionId, ObjectDefinition objectDefinition, ObjectEntry objectEntry, ObjectFieldLocalService objectFieldLocalService, long userId) throws PortalException {
        if (!objectDefinition.isAccountEntryRestricted()) {
            return;
        }
        ObjectField objectField = objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        long accountEntryId = MapUtil.getLong(objectEntry.getValues(), (String)objectField.getName());
        if (accountEntryId == 0L || RoleLocalServiceUtil.hasUserRole((long)userId, (long)objectDefinition.getCompanyId(), (String)"Administrator", (boolean)true)) {
            return;
        }
        long[] accountEntryIds = ListUtil.toLongArray((List)accountEntryLocalService.getUserAccountEntries(userId, Long.valueOf(0L), null, new String[]{"business", "person"}, Integer.valueOf(0), -1, -1), AccountEntryModel::getAccountEntryId);
        if (ArrayUtil.contains((long[])accountEntryIds, (long)accountEntryId)) {
            return;
        }
        if (StringUtil.equals((String)actionId, (String)"DELETE") || StringUtil.equals((String)actionId, (String)"VIEW")) {
            throw new ObjectDefinitionAccountEntryRestrictedException(StringBundler.concat((Object[])new Object[]{"User ", userId, " must have ", actionId, " permission for ", objectDefinition.getClassName(), objectEntry.getObjectEntryId()}));
        }
        throw new ObjectDefinitionAccountEntryRestrictedException(StringBundler.concat((Object[])new Object[]{"The account entry ", accountEntryId, " does not exist or the user ", userId, " does not belong to it"}));
    }
}

