/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.internal.resource.v1_0;

import com.liferay.object.admin.rest.dto.v1_0.ObjectLayout;
import com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutColumn;
import com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutRow;
import com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutTab;
import com.liferay.object.admin.rest.internal.dto.v1_0.util.ObjectLayoutUtil;
import com.liferay.object.admin.rest.internal.resource.v1_0.BaseObjectLayoutResourceImpl;
import com.liferay.object.admin.rest.resource.v1_0.ObjectLayoutResource;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectLayoutBox;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectLayoutService;
import com.liferay.object.service.persistence.ObjectLayoutBoxPersistence;
import com.liferay.object.service.persistence.ObjectLayoutColumnPersistence;
import com.liferay.object.service.persistence.ObjectLayoutRowPersistence;
import com.liferay.object.service.persistence.ObjectLayoutTabPersistence;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/object-layout.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ObjectLayoutResource.class})
public class ObjectLayoutResourceImpl
extends BaseObjectLayoutResourceImpl
implements NestedFieldSupport {
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectLayoutBoxPersistence _objectLayoutBoxPersistence;
    @Reference
    private ObjectLayoutColumnPersistence _objectLayoutColumnPersistence;
    @Reference
    private ObjectLayoutRowPersistence _objectLayoutRowPersistence;
    @Reference
    private ObjectLayoutService _objectLayoutService;
    @Reference
    private ObjectLayoutTabPersistence _objectLayoutTabPersistence;

    @Override
    public void deleteObjectLayout(Long objectLayoutId) throws Exception {
        this._objectLayoutService.deleteObjectLayout(objectLayoutId.longValue());
    }

    @Override
    @NestedField(parentClass=com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition.class, value="objectLayouts")
    public Page<ObjectLayout> getObjectDefinitionObjectLayoutsPage(Long objectDefinitionId, String search, Pagination pagination) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("UPDATE", "postObjectDefinitionObjectLayout", ObjectDefinition.class.getName(), objectDefinitionId)).put((Object)"createBatch", this.addAction("UPDATE", "postObjectDefinitionObjectLayoutBatch", ObjectDefinition.class.getName(), objectDefinitionId)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteObjectLayoutBatch", ObjectDefinition.class.getName(), null)).put((Object)"get", this.addAction("VIEW", "getObjectDefinitionObjectLayoutsPage", ObjectDefinition.class.getName(), objectDefinitionId)).put((Object)"updateBatch", this.addAction("UPDATE", "putObjectLayoutBatch", ObjectDefinition.class.getName(), null)).build(), booleanQuery -> {}, null, (String)com.liferay.object.model.ObjectLayout.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("name", (Serializable)((Object)search));
            searchContext.setAttribute("objectDefinitionId", (Serializable)objectDefinitionId);
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, null, document -> this._toObjectLayout(this._objectLayoutService.getObjectLayout(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public ObjectLayout getObjectLayout(Long objectLayoutId) throws Exception {
        return this._toObjectLayout(this._objectLayoutService.getObjectLayout(objectLayoutId.longValue()));
    }

    @Override
    public ObjectLayout postObjectDefinitionObjectLayout(Long objectDefinitionId, ObjectLayout objectLayout) throws Exception {
        return this._toObjectLayout(this._objectLayoutService.addObjectLayout(objectDefinitionId.longValue(), GetterUtil.getBoolean((Object)objectLayout.getDefaultObjectLayout()), LocalizedMapUtil.getLocalizedMap((Map)objectLayout.getName()), this.transformToList(objectLayout.getObjectLayoutTabs(), objectLayoutTab -> this._toObjectLayoutTab(objectDefinitionId, (ObjectLayoutTab)objectLayoutTab))));
    }

    @Override
    public ObjectLayout putObjectLayout(Long objectLayoutId, ObjectLayout objectLayout) throws Exception {
        return this._toObjectLayout(this._objectLayoutService.updateObjectLayout(objectLayoutId.longValue(), objectLayout.getDefaultObjectLayout().booleanValue(), LocalizedMapUtil.getLocalizedMap((Map)objectLayout.getName()), this.transformToList(objectLayout.getObjectLayoutTabs(), objectLayoutTab -> this._toObjectLayoutTab(objectLayout.getObjectDefinitionId(), (ObjectLayoutTab)objectLayoutTab))));
    }

    private ObjectLayout _toObjectLayout(com.liferay.object.model.ObjectLayout serviceBuilderObjectLayout) {
        return ObjectLayoutUtil.toObjectLayout(HashMapBuilder.put((Object)"delete", this.addAction("DELETE", "deleteObjectLayout", ObjectDefinition.class.getName(), serviceBuilderObjectLayout.getObjectDefinitionId())).put((Object)"get", this.addAction("VIEW", "getObjectLayout", ObjectDefinition.class.getName(), serviceBuilderObjectLayout.getObjectDefinitionId())).put((Object)"update", this.addAction("UPDATE", "putObjectLayout", ObjectDefinition.class.getName(), serviceBuilderObjectLayout.getObjectDefinitionId())).build(), this._objectFieldLocalService, serviceBuilderObjectLayout);
    }

    private ObjectLayoutBox _toObjectLayoutBox(long objectDefinitionId, com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutBox objectLayoutBox) {
        ObjectLayoutBox serviceBuilderObjectLayoutBox = this._objectLayoutBoxPersistence.create(0L);
        serviceBuilderObjectLayoutBox.setCollapsable(objectLayoutBox.getCollapsable().booleanValue());
        serviceBuilderObjectLayoutBox.setNameMap(LocalizedMapUtil.getLocalizedMap((Map)objectLayoutBox.getName()));
        serviceBuilderObjectLayoutBox.setObjectLayoutRows(this.transformToList(objectLayoutBox.getObjectLayoutRows(), objectLayoutRow -> this._toObjectLayoutRow(objectDefinitionId, (ObjectLayoutRow)objectLayoutRow)));
        serviceBuilderObjectLayoutBox.setPriority(objectLayoutBox.getPriority().intValue());
        serviceBuilderObjectLayoutBox.setType(objectLayoutBox.getTypeAsString());
        return serviceBuilderObjectLayoutBox;
    }

    private com.liferay.object.model.ObjectLayoutColumn _toObjectLayoutColumn(long objectDefinitionId, ObjectLayoutColumn objectLayoutColumn) {
        com.liferay.object.model.ObjectLayoutColumn serviceBuilderObjectLayoutColumn = this._objectLayoutColumnPersistence.create(0L);
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId, objectLayoutColumn.getObjectFieldName());
        serviceBuilderObjectLayoutColumn.setObjectFieldId(objectField.getObjectFieldId());
        serviceBuilderObjectLayoutColumn.setPriority(objectLayoutColumn.getPriority().intValue());
        serviceBuilderObjectLayoutColumn.setSize(GetterUtil.getInteger((Object)objectLayoutColumn.getSize(), (int)12));
        return serviceBuilderObjectLayoutColumn;
    }

    private com.liferay.object.model.ObjectLayoutRow _toObjectLayoutRow(long objectDefinitionId, ObjectLayoutRow objectLayoutRow) {
        com.liferay.object.model.ObjectLayoutRow serviceBuilderObjectLayoutRow = this._objectLayoutRowPersistence.create(0L);
        serviceBuilderObjectLayoutRow.setObjectLayoutColumns(this.transformToList(objectLayoutRow.getObjectLayoutColumns(), objectLayoutColumn -> this._toObjectLayoutColumn(objectDefinitionId, (ObjectLayoutColumn)objectLayoutColumn)));
        serviceBuilderObjectLayoutRow.setPriority(objectLayoutRow.getPriority().intValue());
        return serviceBuilderObjectLayoutRow;
    }

    private com.liferay.object.model.ObjectLayoutTab _toObjectLayoutTab(long objectDefinitionId, ObjectLayoutTab objectLayoutTab) {
        com.liferay.object.model.ObjectLayoutTab serviceBuilderObjectLayoutTab = this._objectLayoutTabPersistence.create(0L);
        serviceBuilderObjectLayoutTab.setNameMap(LocalizedMapUtil.getLocalizedMap((Map)objectLayoutTab.getName()));
        serviceBuilderObjectLayoutTab.setObjectLayoutBoxes(this.transformToList(objectLayoutTab.getObjectLayoutBoxes(), objectLayoutBox -> this._toObjectLayoutBox(objectDefinitionId, (com.liferay.object.admin.rest.dto.v1_0.ObjectLayoutBox)objectLayoutBox)));
        serviceBuilderObjectLayoutTab.setObjectRelationshipId(GetterUtil.getLong((Object)objectLayoutTab.getObjectRelationshipId()));
        serviceBuilderObjectLayoutTab.setPriority(objectLayoutTab.getPriority().intValue());
        return serviceBuilderObjectLayoutTab;
    }
}

