/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.client.resource.v1_0;

import com.liferay.object.admin.rest.client.dto.v1_0.ObjectDefinition;
import com.liferay.object.admin.rest.client.http.HttpInvoker;
import com.liferay.object.admin.rest.client.pagination.Page;
import com.liferay.object.admin.rest.client.pagination.Pagination;
import com.liferay.object.admin.rest.client.problem.Problem;
import com.liferay.object.admin.rest.client.serdes.v1_0.ObjectDefinitionSerDes;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface ObjectDefinitionResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<ObjectDefinition> getObjectDefinitionsPage(String var1, List<String> var2, String var3, Pagination var4, String var5) throws Exception;

    public HttpInvoker.HttpResponse getObjectDefinitionsPageHttpResponse(String var1, List<String> var2, String var3, Pagination var4, String var5) throws Exception;

    public ObjectDefinition postObjectDefinition(ObjectDefinition var1) throws Exception;

    public HttpInvoker.HttpResponse postObjectDefinitionHttpResponse(ObjectDefinition var1) throws Exception;

    public void postObjectDefinitionBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse postObjectDefinitionBatchHttpResponse(String var1, Object var2) throws Exception;

    public ObjectDefinition getObjectDefinitionByExternalReferenceCode(String var1) throws Exception;

    public HttpInvoker.HttpResponse getObjectDefinitionByExternalReferenceCodeHttpResponse(String var1) throws Exception;

    public ObjectDefinition putObjectDefinitionByExternalReferenceCode(String var1, ObjectDefinition var2) throws Exception;

    public HttpInvoker.HttpResponse putObjectDefinitionByExternalReferenceCodeHttpResponse(String var1, ObjectDefinition var2) throws Exception;

    public void deleteObjectDefinition(Long var1) throws Exception;

    public HttpInvoker.HttpResponse deleteObjectDefinitionHttpResponse(Long var1) throws Exception;

    public void deleteObjectDefinitionBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse deleteObjectDefinitionBatchHttpResponse(String var1, Object var2) throws Exception;

    public ObjectDefinition getObjectDefinition(Long var1) throws Exception;

    public HttpInvoker.HttpResponse getObjectDefinitionHttpResponse(Long var1) throws Exception;

    public ObjectDefinition patchObjectDefinition(Long var1, ObjectDefinition var2) throws Exception;

    public HttpInvoker.HttpResponse patchObjectDefinitionHttpResponse(Long var1, ObjectDefinition var2) throws Exception;

    public ObjectDefinition putObjectDefinition(Long var1, ObjectDefinition var2) throws Exception;

    public HttpInvoker.HttpResponse putObjectDefinitionHttpResponse(Long var1, ObjectDefinition var2) throws Exception;

    public void putObjectDefinitionBatch(String var1, Object var2) throws Exception;

    public HttpInvoker.HttpResponse putObjectDefinitionBatchHttpResponse(String var1, Object var2) throws Exception;

    public void postObjectDefinitionPublish(Long var1) throws Exception;

    public HttpInvoker.HttpResponse postObjectDefinitionPublishHttpResponse(Long var1) throws Exception;

    public static class ObjectDefinitionResourceImpl
    implements ObjectDefinitionResource {
        private static final Logger _logger = Logger.getLogger(ObjectDefinitionResource.class.getName());
        private Builder _builder;

        @Override
        public Page<ObjectDefinition> getObjectDefinitionsPage(String search, List<String> aggregations, String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getObjectDefinitionsPageHttpResponse(search, aggregations, filterString, pagination, sortString);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, ObjectDefinitionSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getObjectDefinitionsPageHttpResponse(String search, List<String> aggregations, String filterString, Pagination pagination, String sortString) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (search != null) {
                httpInvoker.parameter("search", String.valueOf(search));
            }
            if (filterString != null) {
                httpInvoker.parameter("filter", filterString);
            }
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            if (sortString != null) {
                httpInvoker.parameter("sort", sortString);
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ObjectDefinition postObjectDefinition(ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postObjectDefinitionHttpResponse(objectDefinition);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ObjectDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postObjectDefinitionHttpResponse(ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(objectDefinition.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postObjectDefinitionBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postObjectDefinitionBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postObjectDefinitionBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ObjectDefinition getObjectDefinitionByExternalReferenceCode(String externalReferenceCode) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getObjectDefinitionByExternalReferenceCodeHttpResponse(externalReferenceCode);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ObjectDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getObjectDefinitionByExternalReferenceCodeHttpResponse(String externalReferenceCode) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ObjectDefinition putObjectDefinitionByExternalReferenceCode(String externalReferenceCode, ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putObjectDefinitionByExternalReferenceCodeHttpResponse(externalReferenceCode, objectDefinition);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ObjectDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putObjectDefinitionByExternalReferenceCodeHttpResponse(String externalReferenceCode, ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(objectDefinition.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/by-external-reference-code/{externalReferenceCode}");
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteObjectDefinition(Long objectDefinitionId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteObjectDefinitionHttpResponse(objectDefinitionId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteObjectDefinitionHttpResponse(Long objectDefinitionId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/{objectDefinitionId}");
            httpInvoker.path("objectDefinitionId", objectDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void deleteObjectDefinitionBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.deleteObjectDefinitionBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse deleteObjectDefinitionBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.DELETE);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ObjectDefinition getObjectDefinition(Long objectDefinitionId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getObjectDefinitionHttpResponse(objectDefinitionId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ObjectDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getObjectDefinitionHttpResponse(Long objectDefinitionId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/{objectDefinitionId}");
            httpInvoker.path("objectDefinitionId", objectDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ObjectDefinition patchObjectDefinition(Long objectDefinitionId, ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.patchObjectDefinitionHttpResponse(objectDefinitionId, objectDefinition);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ObjectDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse patchObjectDefinitionHttpResponse(Long objectDefinitionId, ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(objectDefinition.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PATCH);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/{objectDefinitionId}");
            httpInvoker.path("objectDefinitionId", objectDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public ObjectDefinition putObjectDefinition(Long objectDefinitionId, ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putObjectDefinitionHttpResponse(objectDefinitionId, objectDefinition);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return ObjectDefinitionSerDes.toDTO(content);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse putObjectDefinitionHttpResponse(Long objectDefinitionId, ObjectDefinition objectDefinition) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(objectDefinition.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/{objectDefinitionId}");
            httpInvoker.path("objectDefinitionId", objectDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void putObjectDefinitionBatch(String callbackURL, Object object) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.putObjectDefinitionBatchHttpResponse(callbackURL, object);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse putObjectDefinitionBatchHttpResponse(String callbackURL, Object object) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body(object.toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.PUT);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/batch");
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        @Override
        public void postObjectDefinitionPublish(Long objectDefinitionId) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postObjectDefinitionPublishHttpResponse(objectDefinitionId);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postObjectDefinitionPublishHttpResponse(Long objectDefinitionId) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/object-admin/v1.0/object-definitions/{objectDefinitionId}/publish");
            httpInvoker.path("objectDefinitionId", objectDefinitionId);
            httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            return httpInvoker.invoke();
        }

        private ObjectDefinitionResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login = "";
        private String _password = "";
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public ObjectDefinitionResource build() {
            return new ObjectDefinitionResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }
}

