/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.jaxrs.filter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class BaseContextContainerRequestFilter
implements ContainerRequestFilter {
    @Context
    protected Application application;
    @Context
    protected HttpServletRequest httpServletRequest;

    public Bundle getBundle() {
        return FrameworkUtil.getBundle(this.application.getClass());
    }

    public long getCompanyId() {
        return PortalUtil.getCompanyId((HttpServletRequest)this.httpServletRequest);
    }

    protected String getApplicationName() {
        Bundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        Class<?> applicationClass = this.application.getClass();
        String applicationClassName = applicationClass.getName();
        try {
            Collection serviceReferences = bundleContext.getServiceReferences(Application.class, StringBundler.concat((String[])new String[]{"(component.name=", applicationClassName, ")"}));
            if (!serviceReferences.isEmpty()) {
                Iterator iterator = serviceReferences.iterator();
                ServiceReference serviceReference = (ServiceReference)iterator.next();
                return GetterUtil.getString((Object)serviceReference.getProperty("osgi.jaxrs.name"), (String)applicationClassName);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException(invalidSyntaxException);
        }
        return applicationClassName;
    }
}

