/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.liferay;

import com.liferay.oauth2.provider.scope.liferay.ScopedServiceTrackerMap;
import com.liferay.oauth2.provider.scope.liferay.ScopedServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;

@Component
public class ScopedServiceTrackerMapFactoryImpl
implements ScopedServiceTrackerMapFactory {
    public <T> ScopedServiceTrackerMap<T> create(BundleContext bundleContext, Class<T> clazz, String property, Supplier<T> defaultServiceSupplier, Runnable onChangeRunnable) {
        return new ScopedServiceTrackerMapImpl(bundleContext, clazz, property, defaultServiceSupplier, onChangeRunnable);
    }

    private static class ScopedServiceTrackerMapImpl<T>
    implements ScopedServiceTrackerMap<T> {
        private final Supplier<T> _defaultServiceSupplier;
        private final Runnable _onChangeRunnable;
        private final ServiceTrackerMap<String, List<T>> _servicesByCompany;
        private final ServiceTrackerMap<String, List<T>> _servicesByCompanyAndKey;
        private final ServiceTrackerMap<String, List<T>> _servicesByKey;

        public void close() {
            this._servicesByCompany.close();
            this._servicesByCompanyAndKey.close();
            this._servicesByKey.close();
        }

        public T getService(long companyId, String key) {
            String companyIdString = String.valueOf(companyId);
            List services = (List)this._servicesByCompanyAndKey.getService((Object)String.join((CharSequence)"-", companyIdString, key));
            if (ListUtil.isNotEmpty((List)services)) {
                return (T)services.get(0);
            }
            services = (List)this._servicesByKey.getService((Object)key);
            if (ListUtil.isNotEmpty((List)services)) {
                return (T)services.get(0);
            }
            services = (List)this._servicesByCompany.getService((Object)companyIdString);
            if (ListUtil.isNotEmpty((List)services)) {
                return (T)services.get(0);
            }
            return this._defaultServiceSupplier.get();
        }

        private ScopedServiceTrackerMapImpl(BundleContext bundleContext, Class<T> clazz, String property, Supplier<T> defaultServiceSupplier, Runnable onChangeRunnable) {
            this._defaultServiceSupplier = defaultServiceSupplier;
            this._onChangeRunnable = onChangeRunnable;
            this._servicesByCompany = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, clazz, (String)StringBundler.concat((String[])new String[]{"(&(companyId=*)(!(", property, "=*)))"}), (ServiceReferenceMapper)new PropertyServiceReferenceMapper("companyId"), (ServiceTrackerMapListener)new ServiceTrackerMapListenerImpl());
            this._servicesByCompanyAndKey = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, clazz, (String)StringBundler.concat((String[])new String[]{"(&(companyId=*)(", property, "=*))"}), (serviceReference, emitter) -> {
                PropertyServiceReferenceMapper companyMapper = new PropertyServiceReferenceMapper("companyId");
                PropertyServiceReferenceMapper nameMapper = new PropertyServiceReferenceMapper(property);
                companyMapper.map(serviceReference, arg_0 -> ScopedServiceTrackerMapImpl.lambda$null$1((ServiceReferenceMapper)nameMapper, serviceReference, emitter, arg_0));
            }, (ServiceTrackerMapListener)new ServiceTrackerMapListenerImpl());
            this._servicesByKey = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, clazz, (String)StringBundler.concat((String[])new String[]{"(&(", property, "=*)(|(!(companyId=*))(companyId=0)))"}), (ServiceReferenceMapper)new PropertyServiceReferenceMapper(property), (ServiceTrackerMapListener)new ServiceTrackerMapListenerImpl());
        }

        private static /* synthetic */ void lambda$null$1(ServiceReferenceMapper nameMapper, ServiceReference serviceReference, ServiceReferenceMapper.Emitter emitter, String key1) {
            nameMapper.map(serviceReference, key2 -> emitter.emit((Object)String.join((CharSequence)"-", key1, key2)));
        }

        private class ServiceTrackerMapListenerImpl
        implements ServiceTrackerMapListener<String, T, List<T>> {
            private ServiceTrackerMapListenerImpl() {
            }

            public void keyEmitted(ServiceTrackerMap<String, List<T>> serviceTrackerMap, String key, T service, List<T> content) {
                ScopedServiceTrackerMapImpl.this._onChangeRunnable.run();
            }

            public void keyRemoved(ServiceTrackerMap<String, List<T>> serviceTrackerMap, String key, T service, List<T> content) {
                ScopedServiceTrackerMapImpl.this._onChangeRunnable.run();
            }
        }
    }
}

