/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.liferay;

import com.liferay.oauth2.provider.scope.internal.liferay.LiferayOAuth2ScopeImpl;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.scope.liferay.ScopedServiceTrackerMap;
import com.liferay.oauth2.provider.scope.liferay.ScopedServiceTrackerMapFactory;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandler;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandlerFactory;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.oauth2.provider.scope.spi.scope.mapper.ScopeMapper;
import com.liferay.oauth2.provider.scope.spi.scope.matcher.ScopeMatcher;
import com.liferay.oauth2.provider.scope.spi.scope.matcher.ScopeMatcherFactory;
import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={ScopeLocator.class})
public class ScopeLocatorImpl
implements ScopeLocator {
    private BundleContext _bundleContext;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(osgi.jaxrs.name=Default)")
    private volatile PrefixHandlerFactory _defaultPrefixHandlerFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(osgi.jaxrs.name=Default)")
    private volatile ScopeMapper _defaultScopeMapper;
    private ScopeMatcherFactory _defaultScopeMatcherFactory;
    private ScopedServiceTrackerMap<PrefixHandlerFactory> _scopedPrefixHandlerFactories;
    private ScopedServiceTrackerMap<ScopeFinder> _scopedScopeFinders;
    private ScopedServiceTrackerMap<ScopeMapper> _scopedScopeMapper;
    private ServiceTrackerMap<String, ScopeMatcherFactory> _scopedScopeMatcherFactories;
    private ScopedServiceTrackerMapFactory _scopedServiceTrackerMapFactory;
    private ServiceTrackerMap<String, ServiceReferenceServiceTuple<?, ScopeFinder>> _scopeFinderByNameServiceTrackerMap;

    public Collection<LiferayOAuth2Scope> getLiferayOAuth2Scopes(long companyId, String scopesAlias) {
        Set names = this._scopeFinderByNameServiceTrackerMap.keySet();
        ArrayList<LiferayOAuth2Scope> liferayOAuth2Scopes = new ArrayList<LiferayOAuth2Scope>();
        for (String name : names) {
            liferayOAuth2Scopes.addAll(this.getLiferayOAuth2Scopes(companyId, scopesAlias, name));
        }
        return liferayOAuth2Scopes;
    }

    public Collection<LiferayOAuth2Scope> getLiferayOAuth2Scopes(long companyId, String scopesAlias, String applicationName) {
        ScopeFinder scopeFinder = (ScopeFinder)this._scopedScopeFinders.getService(companyId, applicationName);
        Collection scopes = scopeFinder.findScopes();
        if (scopes.isEmpty()) {
            return Collections.emptyList();
        }
        ServiceReferenceServiceTuple serviceReferenceServiceTuple = (ServiceReferenceServiceTuple)this._scopeFinderByNameServiceTrackerMap.getService((Object)applicationName);
        PrefixHandlerFactory prefixHandlerFactory = (PrefixHandlerFactory)this._scopedPrefixHandlerFactories.getService(companyId, applicationName);
        ServiceReference serviceReference = serviceReferenceServiceTuple.getServiceReference();
        Bundle bundle = this.getBundle(serviceReference);
        HashSet<LiferayOAuth2Scope> locatedScopes = new HashSet<LiferayOAuth2Scope>(scopes.size());
        HashMap<String, Boolean> matchCache = new HashMap<String, Boolean>();
        PrefixHandler prefixHandler = prefixHandlerFactory.create(arg_0 -> ((ServiceReference)serviceReference).getProperty(arg_0));
        ScopeMapper scopeMapper = (ScopeMapper)this._scopedScopeMapper.getService(companyId, applicationName);
        ScopeMatcherFactory scopeMatcherFactory = this.getScopeMatcherFactory(companyId);
        for (String scope : scopes) {
            for (String mappedScope : scopeMapper.map(scope)) {
                boolean matched = matchCache.computeIfAbsent(mappedScope, input -> this.scopeMatchesScopesAlias((String)input, scopeMatcherFactory, prefixHandler, scopesAlias));
                if (!matched) continue;
                locatedScopes.add(new LiferayOAuth2ScopeImpl(applicationName, bundle, scope));
            }
        }
        return locatedScopes;
    }

    public Collection<String> getScopeAliases(long companyId) {
        HashSet<String> scopesAliases = new HashSet<String>();
        Set applicationNames = this._scopeFinderByNameServiceTrackerMap.keySet();
        for (String applicationName : applicationNames) {
            scopesAliases.addAll(this.getScopeAliases(companyId, applicationName));
        }
        return scopesAliases;
    }

    public Collection<String> getScopeAliases(long companyId, String applicationName) {
        ServiceReferenceServiceTuple serviceReferenceServiceTuple = (ServiceReferenceServiceTuple)this._scopeFinderByNameServiceTrackerMap.getService((Object)applicationName);
        PrefixHandlerFactory prefixHandlerFactory = (PrefixHandlerFactory)this._scopedPrefixHandlerFactories.getService(companyId, applicationName);
        ServiceReference serviceReference = serviceReferenceServiceTuple.getServiceReference();
        PrefixHandler prefixHandler = prefixHandlerFactory.create(arg_0 -> ((ServiceReference)serviceReference).getProperty(arg_0));
        ScopeFinder scopeFinder = (ScopeFinder)this._scopedScopeFinders.getService(companyId, applicationName);
        ScopeMapper scopeMapper = (ScopeMapper)this._scopedScopeMapper.getService(companyId, applicationName);
        Collection scopes = scopeFinder.findScopes();
        ArrayList<String> scopesAliases = new ArrayList<String>();
        for (String scope : scopes) {
            Set mappedScopes = scopeMapper.map(scope);
            for (String mappedScope : mappedScopes) {
                String externalAlias = prefixHandler.addPrefix(mappedScope);
                scopesAliases.add(externalAlias);
            }
        }
        return scopesAliases;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this.setScopedPrefixHandlerFactories((ScopedServiceTrackerMap<PrefixHandlerFactory>)this._scopedServiceTrackerMapFactory.create(bundleContext, PrefixHandlerFactory.class, "osgi.jaxrs.name", () -> {
            PrefixHandlerFactory prefixHandlerFactory = this._defaultPrefixHandlerFactory;
            if (prefixHandlerFactory != null) {
                return prefixHandlerFactory;
            }
            return propertyAccessor -> PrefixHandler.PASSTHROUGH_PREFIXHANDLER;
        }));
        this.setScopedScopeFinders((ScopedServiceTrackerMap<ScopeFinder>)this._scopedServiceTrackerMapFactory.create(bundleContext, ScopeFinder.class, "osgi.jaxrs.name", () -> null));
        this.setScopedScopeMapper((ScopedServiceTrackerMap<ScopeMapper>)this._scopedServiceTrackerMapFactory.create(bundleContext, ScopeMapper.class, "osgi.jaxrs.name", () -> {
            ScopeMapper scopeMapper = this._defaultScopeMapper;
            if (scopeMapper != null) {
                return scopeMapper;
            }
            return ScopeMapper.PASSTHROUGH_SCOPEMAPPER;
        }));
        this.setScopedScopeMatcherFactories((ServiceTrackerMap<String, ScopeMatcherFactory>)ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ScopeMatcherFactory.class, (String)"company.id"));
        this.setScopeFinderByNameServiceTrackerMap(ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ScopeFinder.class, (String)"osgi.jaxrs.name", (ServiceTrackerCustomizer)new ScopeFinderServiceTupleServiceTrackerCustomizer(bundleContext)));
    }

    @Deactivate
    protected void deactivate() {
        this._scopeFinderByNameServiceTrackerMap.close();
        this._scopedPrefixHandlerFactories.close();
        this._scopedScopeFinders.close();
        this._scopedScopeMapper.close();
        this._scopedScopeMatcherFactories.close();
    }

    protected Bundle getBundle(ServiceReference<?> serviceReference) {
        Object property = serviceReference.getProperty("original.service.bundleid");
        if (property == null) {
            return serviceReference.getBundle();
        }
        long bundleId = GetterUtil.getLong((Object)property, (long)-1L);
        if (bundleId == -1L) {
            return serviceReference.getBundle();
        }
        Bundle bundle = this._bundleContext.getBundle(bundleId);
        if (bundle == null) {
            return serviceReference.getBundle();
        }
        return bundle;
    }

    protected ScopeMatcherFactory getScopeMatcherFactory(long companyId) {
        ScopeMatcherFactory scopeMatcherFactory = (ScopeMatcherFactory)this._scopedScopeMatcherFactories.getService((Object)String.valueOf(companyId));
        if (scopeMatcherFactory == null) {
            return this._defaultScopeMatcherFactory;
        }
        return scopeMatcherFactory;
    }

    protected boolean scopeMatchesScopesAlias(String scope, ScopeMatcherFactory scopeMatcherFactory, PrefixHandler prefixHandler, String scopesAlias) {
        String prefixedScope = prefixHandler.addPrefix(scope);
        if (scope.length() > prefixedScope.length()) {
            return false;
        }
        String prefix = prefixedScope.substring(0, prefixedScope.length() - scope.length());
        if (!scopesAlias.startsWith(prefix)) {
            return false;
        }
        ScopeMatcher scopeMatcher = scopeMatcherFactory.create(scopesAlias.substring(prefix.length()));
        return scopeMatcher.match(scope);
    }

    @Reference(name="default", unbind="-")
    protected void setDefaultScopeMatcherFactory(ScopeMatcherFactory defaultScopeMatcherFactory) {
        this._defaultScopeMatcherFactory = defaultScopeMatcherFactory;
    }

    protected void setScopedPrefixHandlerFactories(ScopedServiceTrackerMap<PrefixHandlerFactory> scopedPrefixHandlerFactories) {
        this._scopedPrefixHandlerFactories = scopedPrefixHandlerFactories;
    }

    protected void setScopedScopeFinders(ScopedServiceTrackerMap<ScopeFinder> scopedScopeFinders) {
        this._scopedScopeFinders = scopedScopeFinders;
    }

    protected void setScopedScopeMapper(ScopedServiceTrackerMap<ScopeMapper> scopedScopeMapper) {
        this._scopedScopeMapper = scopedScopeMapper;
    }

    protected void setScopedScopeMatcherFactories(ServiceTrackerMap<String, ScopeMatcherFactory> scopedScopeMatcherFactories) {
        this._scopedScopeMatcherFactories = scopedScopeMatcherFactories;
    }

    @Reference(unbind="-")
    protected void setScopedServiceTrackerMapFactory(ScopedServiceTrackerMapFactory scopedServiceTrackerMapFactory) {
        this._scopedServiceTrackerMapFactory = scopedServiceTrackerMapFactory;
    }

    protected void setScopeFinderByNameServiceTrackerMap(ServiceTrackerMap<String, ServiceReferenceServiceTuple<?, ScopeFinder>> scopeFinderByNameServiceTrackerMap) {
        this._scopeFinderByNameServiceTrackerMap = scopeFinderByNameServiceTrackerMap;
    }

    private static class ScopeFinderServiceTupleServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ScopeFinder, ServiceReferenceServiceTuple<?, ScopeFinder>> {
        private final BundleContext _bundleContext;

        public ScopeFinderServiceTupleServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public ServiceReferenceServiceTuple<?, ScopeFinder> addingService(ServiceReference<ScopeFinder> serviceReference) {
            ScopeFinder scopeFinder = (ScopeFinder)this._bundleContext.getService(serviceReference);
            return new ServiceReferenceServiceTuple(serviceReference, (Object)scopeFinder);
        }

        public void modifiedService(ServiceReference<ScopeFinder> serviceReference, ServiceReferenceServiceTuple<?, ScopeFinder> serviceReferenceServiceTuple) {
        }

        public void removedService(ServiceReference<ScopeFinder> serviceReference, ServiceReferenceServiceTuple<?, ScopeFinder> serviceReferenceServiceTuple) {
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

