/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.jaxrs.feature;

import com.liferay.oauth2.provider.scope.internal.jaxrs.filter.AbstractContextContainerRequestFilter;
import com.liferay.oauth2.provider.scope.liferay.ScopeContext;
import com.liferay.oauth2.provider.scope.spi.application.descriptor.ApplicationDescriptor;
import com.liferay.oauth2.provider.scope.spi.scope.descriptor.ScopeDescriptor;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.util.tracker.ServiceTracker;

@Provider
@Component(property={"auth.verifier.application.select=(!(osgi.jaxrs.name=*))", "liferay.extension=OAuth2", "osgi.jaxrs.application.select=(!(liferay.oauth2=false))", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=Liferay.OAuth2"}, scope=ServiceScope.PROTOTYPE, service={Feature.class})
public class LiferayOAuth2OSGiFeature
implements Feature {
    private static final Log _log = LogFactoryUtil.getLog(LiferayOAuth2OSGiFeature.class);
    @Context
    private Application _application;
    private Filter _authVerifierApplicationSelectFilter;
    private Bundle _bundle;
    private BundleContext _bundleContext;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(default=true)")
    private volatile ScopeDescriptor _defaultScopeDescriptor;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ScopeContext _scopeContext;
    private final Collection<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
    private final Collection<ServiceTracker<?, ?>> _serviceTrackers = new ArrayList();

    public boolean configure(FeatureContext featureContext) {
        Configuration configuration = featureContext.getConfiguration();
        Map applicationProperties = (Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties");
        Class<?> applicationClass = this._application.getClass();
        final String osgiJAXRSName = MapUtil.getString((Map)applicationProperties, (String)"osgi.jaxrs.name", (String)applicationClass.getName());
        featureContext.register((Object)new AbstractContextContainerRequestFilter(){

            public void filter(ContainerRequestContext requestContext) {
                LiferayOAuth2OSGiFeature.this._scopeContext.setApplicationName(osgiJAXRSName);
                LiferayOAuth2OSGiFeature.this._scopeContext.setBundle(LiferayOAuth2OSGiFeature.this._bundle);
                LiferayOAuth2OSGiFeature.this._scopeContext.setCompanyId(this.getCompanyId());
            }
        }, 1990);
        featureContext.register((a, b) -> this._scopeContext.clear(), 1991);
        if (this._authVerifierApplicationSelectFilter != null && this._authVerifierApplicationSelectFilter.matches(applicationProperties)) {
            this.registerAuthVerifierFilter(MapUtil.getString((Map)applicationProperties, (String)"osgi.http.whiteboard.context.select", (String)StringBundler.concat((String[])new String[]{"(", "osgi.http.whiteboard.context.name", "=context.for", osgiJAXRSName, ")"})));
        }
        this.registerDescriptors(osgiJAXRSName);
        return true;
    }

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this._bundle = componentContext.getUsingBundle();
        this._bundleContext = componentContext.getBundleContext();
        String authVerifierApplicationSelectFilterString = MapUtil.getString(properties, (String)"auth.verifier.application.select");
        if (Validator.isNotNull((String)authVerifierApplicationSelectFilterString)) {
            try {
                this._authVerifierApplicationSelectFilter = this._bundleContext.createFilter(authVerifierApplicationSelectFilterString);
            }
            catch (InvalidSyntaxException ise) {
                _log.error((Object)("Invalid filter: " + authVerifierApplicationSelectFilterString), (Throwable)ise);
            }
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)"auth.verifier.application.select is empty");
        }
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception exception) {}
        }
        for (ServiceTracker serviceTracker : this._serviceTrackers) {
            serviceTracker.close();
        }
    }

    protected void registerAuthVerifierFilter(String contextSelect) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", contextSelect);
        ((Dictionary)properties).put("filter.init.auth.verifier.OAuth2RestAuthVerifier.urls.includes", "*");
        ((Dictionary)properties).put("osgi.http.whiteboard.filter.name", AuthVerifierFilter.class.getName());
        ((Dictionary)properties).put("osgi.http.whiteboard.filter.servlet", "cxf-servlet");
        this._serviceRegistrations.add(this._bundleContext.registerService(javax.servlet.Filter.class, (Object)new AuthVerifierFilter(), properties));
    }

    protected void registerDescriptors(String osgiJAXRSName) {
        String bundleSymbolicName = this._bundle.getSymbolicName();
        StringBundler sb = new StringBundler(5);
        sb.append("(&(bundle.symbolic.name=");
        sb.append(bundleSymbolicName);
        sb.append(")(objectClass=");
        sb.append(ResourceBundleLoader.class.getName());
        sb.append(")(resource.bundle.base.name=content.Language))");
        ServiceTracker serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)sb.toString());
        this._serviceTrackers.add(serviceTracker);
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.jaxrs.name", osgiJAXRSName);
        this._serviceRegistrations.add(this._bundleContext.registerService(new String[]{ScopeDescriptor.class.getName(), ApplicationDescriptor.class.getName()}, (Object)new ApplicationDescriptorsImpl(serviceTracker, osgiJAXRSName), (Dictionary)properties));
    }

    private class ApplicationDescriptorsImpl
    implements ScopeDescriptor,
    ApplicationDescriptor {
        private final String _osgiJAXRSName;
        private final ServiceTracker<?, ResourceBundleLoader> _serviceTracker;

        public ApplicationDescriptorsImpl(ServiceTracker<?, ResourceBundleLoader> serviceTracker, String osgiJAXRSName) {
            this._serviceTracker = serviceTracker;
            this._osgiJAXRSName = osgiJAXRSName;
        }

        public String describeApplication(Locale locale) {
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)this._serviceTracker.getService();
            if (resourceBundleLoader == null) {
                return this._osgiJAXRSName;
            }
            String key = "oauth2.application.description." + this._osgiJAXRSName;
            return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundleLoader.loadResourceBundle(locale), (String)key), (String)key);
        }

        public String describeScope(String scope, Locale locale) {
            ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)this._serviceTracker.getService();
            if (resourceBundleLoader == null) {
                return LiferayOAuth2OSGiFeature.this._defaultScopeDescriptor.describeScope(scope, locale);
            }
            String key = "oauth2.scope." + scope;
            return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundleLoader.loadResourceBundle(locale), (String)key), (String)LiferayOAuth2OSGiFeature.this._defaultScopeDescriptor.describeScope(scope, locale));
        }
    }
}

