/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service;

import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.util.List;

public class OAuth2ApplicationServiceUtil {
    private static volatile OAuth2ApplicationService _service;

    public static OAuth2Application addOAuth2Application(List<GrantType> allowedGrantTypesList, String clientAuthenticationMethod, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String jwks, String name, String privacyPolicyURL, List<String> redirectURIsList, boolean rememberDevice, List<String> scopeAliasesList, boolean trustedApplication, ServiceContext serviceContext) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().addOAuth2Application(allowedGrantTypesList, clientAuthenticationMethod, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, jwks, name, privacyPolicyURL, redirectURIsList, rememberDevice, scopeAliasesList, trustedApplication, serviceContext);
    }

    public static OAuth2Application deleteOAuth2Application(long oAuth2ApplicationId) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().deleteOAuth2Application(oAuth2ApplicationId);
    }

    public static OAuth2Application fetchOAuth2Application(long companyId, String clientId) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().fetchOAuth2Application(companyId, clientId);
    }

    public static OAuth2Application getOAuth2Application(long oAuth2ApplicationId) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().getOAuth2Application(oAuth2ApplicationId);
    }

    public static OAuth2Application getOAuth2Application(long companyId, String clientId) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().getOAuth2Application(companyId, clientId);
    }

    public static List<OAuth2Application> getOAuth2Applications(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return OAuth2ApplicationServiceUtil.getService().getOAuth2Applications(companyId, start, end, orderByComparator);
    }

    public static int getOAuth2ApplicationsCount(long companyId) {
        return OAuth2ApplicationServiceUtil.getService().getOAuth2ApplicationsCount(companyId);
    }

    public static String getOSGiServiceIdentifier() {
        return OAuth2ApplicationServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static OAuth2Application updateIcon(long oAuth2ApplicationId, InputStream inputStream) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().updateIcon(oAuth2ApplicationId, inputStream);
    }

    public static OAuth2Application updateOAuth2Application(long oAuth2ApplicationId, long oAuth2ApplicationScopeAliasesId, List<GrantType> allowedGrantTypesList, String clientAuthenticationMethod, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String jwks, String name, String privacyPolicyURL, List<String> redirectURIsList, boolean rememberDevice, boolean trustedApplication) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().updateOAuth2Application(oAuth2ApplicationId, oAuth2ApplicationScopeAliasesId, allowedGrantTypesList, clientAuthenticationMethod, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, jwks, name, privacyPolicyURL, redirectURIsList, rememberDevice, trustedApplication);
    }

    public static OAuth2Application updateScopeAliases(long oAuth2ApplicationId, List<String> scopeAliasesList) throws PortalException {
        return OAuth2ApplicationServiceUtil.getService().updateScopeAliases(oAuth2ApplicationId, scopeAliasesList);
    }

    public static OAuth2ApplicationService getService() {
        return _service;
    }
}

