/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service;

import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.exception.NoSuchOAuth2ApplicationException;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.util.builder.OAuth2ScopeBuilder;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;

public class OAuth2ApplicationLocalServiceUtil {
    private static volatile OAuth2ApplicationLocalService _service;

    public static OAuth2Application addOAuth2Application(long companyId, long userId, String userName, List<GrantType> allowedGrantTypesList, String clientAuthenticationMethod, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String jwks, String name, String privacyPolicyURL, List<String> redirectURIsList, boolean rememberDevice, boolean trustedApplication, Consumer<OAuth2ScopeBuilder> builderConsumer, ServiceContext serviceContext) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().addOAuth2Application(companyId, userId, userName, allowedGrantTypesList, clientAuthenticationMethod, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, jwks, name, privacyPolicyURL, redirectURIsList, rememberDevice, trustedApplication, builderConsumer, serviceContext);
    }

    public static OAuth2Application addOAuth2Application(long companyId, long userId, String userName, List<GrantType> allowedGrantTypesList, String clientAuthenticationMethod, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String jwks, String name, String privacyPolicyURL, List<String> redirectURIsList, boolean rememberDevice, List<String> scopeAliasesList, boolean trustedApplication, ServiceContext serviceContext) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().addOAuth2Application(companyId, userId, userName, allowedGrantTypesList, clientAuthenticationMethod, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, jwks, name, privacyPolicyURL, redirectURIsList, rememberDevice, scopeAliasesList, trustedApplication, serviceContext);
    }

    public static OAuth2Application addOAuth2Application(OAuth2Application oAuth2Application) {
        return OAuth2ApplicationLocalServiceUtil.getService().addOAuth2Application(oAuth2Application);
    }

    public static OAuth2Application createOAuth2Application(long oAuth2ApplicationId) {
        return OAuth2ApplicationLocalServiceUtil.getService().createOAuth2Application(oAuth2ApplicationId);
    }

    public static PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().createPersistedModel(primaryKeyObj);
    }

    public static OAuth2Application deleteOAuth2Application(long oAuth2ApplicationId) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().deleteOAuth2Application(oAuth2ApplicationId);
    }

    public static OAuth2Application deleteOAuth2Application(OAuth2Application oAuth2Application) {
        return OAuth2ApplicationLocalServiceUtil.getService().deleteOAuth2Application(oAuth2Application);
    }

    public static void deleteOAuth2Applications(long companyId) throws PortalException {
        OAuth2ApplicationLocalServiceUtil.getService().deleteOAuth2Applications(companyId);
    }

    public static PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().deletePersistedModel(persistedModel);
    }

    public static <T> T dslQuery(DSLQuery dslQuery) {
        return OAuth2ApplicationLocalServiceUtil.getService().dslQuery(dslQuery);
    }

    public static int dslQueryCount(DSLQuery dslQuery) {
        return OAuth2ApplicationLocalServiceUtil.getService().dslQueryCount(dslQuery);
    }

    public static DynamicQuery dynamicQuery() {
        return OAuth2ApplicationLocalServiceUtil.getService().dynamicQuery();
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return OAuth2ApplicationLocalServiceUtil.getService().dynamicQuery(dynamicQuery);
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return OAuth2ApplicationLocalServiceUtil.getService().dynamicQuery(dynamicQuery, start, end);
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return OAuth2ApplicationLocalServiceUtil.getService().dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public static long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return OAuth2ApplicationLocalServiceUtil.getService().dynamicQueryCount(dynamicQuery);
    }

    public static long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return OAuth2ApplicationLocalServiceUtil.getService().dynamicQueryCount(dynamicQuery, projection);
    }

    public static OAuth2Application fetchOAuth2Application(long oAuth2ApplicationId) {
        return OAuth2ApplicationLocalServiceUtil.getService().fetchOAuth2Application(oAuth2ApplicationId);
    }

    public static OAuth2Application fetchOAuth2Application(long companyId, String clientId) {
        return OAuth2ApplicationLocalServiceUtil.getService().fetchOAuth2Application(companyId, clientId);
    }

    public static ActionableDynamicQuery getActionableDynamicQuery() {
        return OAuth2ApplicationLocalServiceUtil.getService().getActionableDynamicQuery();
    }

    public static IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        return OAuth2ApplicationLocalServiceUtil.getService().getIndexableActionableDynamicQuery();
    }

    public static OAuth2Application getOAuth2Application(long oAuth2ApplicationId) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().getOAuth2Application(oAuth2ApplicationId);
    }

    public static OAuth2Application getOAuth2Application(long companyId, String clientId) throws NoSuchOAuth2ApplicationException {
        return OAuth2ApplicationLocalServiceUtil.getService().getOAuth2Application(companyId, clientId);
    }

    public static List<OAuth2Application> getOAuth2Applications(int start, int end) {
        return OAuth2ApplicationLocalServiceUtil.getService().getOAuth2Applications(start, end);
    }

    public static List<OAuth2Application> getOAuth2Applications(long companyId) {
        return OAuth2ApplicationLocalServiceUtil.getService().getOAuth2Applications(companyId);
    }

    public static int getOAuth2ApplicationsCount() {
        return OAuth2ApplicationLocalServiceUtil.getService().getOAuth2ApplicationsCount();
    }

    public static String getOSGiServiceIdentifier() {
        return OAuth2ApplicationLocalServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().getPersistedModel(primaryKeyObj);
    }

    public static OAuth2Application updateIcon(long oAuth2ApplicationId, InputStream inputStream) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().updateIcon(oAuth2ApplicationId, inputStream);
    }

    public static OAuth2Application updateOAuth2Application(long oAuth2ApplicationId, long oAuth2ApplicationScopeAliasesId, List<GrantType> allowedGrantTypesList, String clientAuthenticationMethod, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String jwks, String name, String privacyPolicyURL, List<String> redirectURIsList, boolean rememberDevice, boolean trustedApplication) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().updateOAuth2Application(oAuth2ApplicationId, oAuth2ApplicationScopeAliasesId, allowedGrantTypesList, clientAuthenticationMethod, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, jwks, name, privacyPolicyURL, redirectURIsList, rememberDevice, trustedApplication);
    }

    public static OAuth2Application updateOAuth2Application(OAuth2Application oAuth2Application) {
        return OAuth2ApplicationLocalServiceUtil.getService().updateOAuth2Application(oAuth2Application);
    }

    public static OAuth2Application updateScopeAliases(long userId, String userName, long oAuth2ApplicationId, List<String> scopeAliasesList) throws PortalException {
        return OAuth2ApplicationLocalServiceUtil.getService().updateScopeAliases(userId, userName, oAuth2ApplicationId, scopeAliasesList);
    }

    public static OAuth2ApplicationLocalService getService() {
        return _service;
    }
}

