/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth2SecureRandomGenerator {
    private static final Pattern _baseIdPattern = Pattern.compile("(.{8})(.{4})(.{4})(.{4})(.*)");

    public static String generateClientId() {
        Matcher matcher = _baseIdPattern.matcher(OAuth2SecureRandomGenerator.generateSecureRandomString());
        return matcher.replaceFirst("id-$1-$2-$3-$4-$5");
    }

    public static String generateClientSecret() {
        Matcher matcher = _baseIdPattern.matcher(OAuth2SecureRandomGenerator.generateSecureRandomString());
        return matcher.replaceFirst("secret-$1-$2-$3-$4-$5");
    }

    protected static String generateSecureRandomString() {
        int i;
        int size = 16;
        StringBundler sb = new StringBundler(size);
        int count = (int)Math.ceil((double)size / 8.0);
        byte[] buffer = new byte[count * 8];
        for (i = 0; i < count; ++i) {
            BigEndianCodec.putLong((byte[])buffer, (int)(i * 8), (long)SecureRandomUtil.nextLong());
        }
        for (i = 0; i < size; ++i) {
            sb.append(Integer.toHexString(0xFF & buffer[i]));
        }
        return sb.toString();
    }
}

