/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.web.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class UpgradeUserNotificationEvent
extends UpgradeProcess {
    private final UserNotificationEventLocalService _userNotificationEventLocalService;

    public UpgradeUserNotificationEvent(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.updateUserNotificationEvents();
    }

    protected void updateUserNotificationEvents() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List userNotificationEvents = this._userNotificationEventLocalService.getTypeNotificationEvents("6_WAR_soportlet");
            for (UserNotificationEvent userNotificationEvent : userNotificationEvents) {
                long memberRequestId;
                JSONObject payloadJSONObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
                String type = payloadJSONObject.getString("portletId");
                if (Validator.isNull((String)type)) {
                    return;
                }
                payloadJSONObject.remove("portletId");
                long entryId = payloadJSONObject.getLong("entryId");
                if (entryId > 0L) {
                    payloadJSONObject.put("classPK", entryId);
                    payloadJSONObject.remove("entryId");
                } else if (type.equals("1_WAR_contactsportlet")) {
                    long socialRequestId = payloadJSONObject.getLong("requestId");
                    if (socialRequestId > 0L) {
                        payloadJSONObject.put("classPK", socialRequestId);
                        payloadJSONObject.remove("socialRequestId");
                    }
                } else if (type.equals("2_WAR_soportlet") && (memberRequestId = payloadJSONObject.getLong("memberRequestId")) > 0L) {
                    payloadJSONObject.put("classPK", memberRequestId);
                    payloadJSONObject.remove("memberRequestId");
                }
                userNotificationEvent.setType(type);
                userNotificationEvent.setPayload(payloadJSONObject.toString());
                this._userNotificationEventLocalService.updateUserNotificationEvent(userNotificationEvent);
            }
        }
    }
}

