/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.web.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelListener.class);
    @Reference
    private UserNotificationDeliveryLocalService _userNotificationDeliveryLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public void onAfterRemove(User user) throws ModelListenerException {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing chat entries and status for user " + user.getUserId()));
            }
            this._userNotificationDeliveryLocalService.deleteUserNotificationDeliveries(user.getUserId());
            this._userNotificationEventLocalService.deleteUserNotificationEvents(user.getUserId());
        }
        catch (Exception e) {
            _log.error((Object)("Unable to remove chat entries and status for user " + user.getUserId()), (Throwable)e);
        }
    }
}

