/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class NotificationsManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;

    public NotificationsManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, PortletURL currentURLObj) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._httpServletRequest = httpServletRequest;
        this._currentURLObj = currentURLObj;
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                if (!NotificationsManagementToolbarDisplayContext.this._isActionRequired()) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "markNotificationsAsRead");
                        dropdownItem.setIcon("envelope-open");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"mark-as-read"));
                        dropdownItem.setQuickAction(true);
                    });
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "markNotificationsAsUnread");
                        dropdownItem.setIcon("envelope-closed");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"mark-as-unread"));
                        dropdownItem.setQuickAction(true);
                    });
                }
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteNotifications");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this._liferayPortletResponse.createRenderURL();
        clearResultsURL.setParameter("actionRequired", String.valueOf(this._isActionRequired()));
        return clearResultsURL.toString();
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                if (!NotificationsManagementToolbarDisplayContext.this._isActionRequired()) {
                    this.addGroup(dropdownGroupItem -> {
                        dropdownGroupItem.setDropdownItems(NotificationsManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                        dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"filter-by-navigation"));
                    });
                }
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(NotificationsManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public List<LabelItem> getFilterLabelItems() {
        return new LabelItemList(){
            {
                String navigation = NotificationsManagementToolbarDisplayContext.this._getNavigation();
                if (navigation.equals("read") || navigation.equals("unread")) {
                    this.add(labelItem -> {
                        PortletURL removeLabelURL = PortletURLUtil.clone((PortletURL)NotificationsManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)NotificationsManagementToolbarDisplayContext.this._liferayPortletResponse);
                        removeLabelURL.setParameter("navigation", (String)null);
                        labelItem.putData("removeLabelURL", removeLabelURL.toString());
                        labelItem.setCloseable(true);
                        labelItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)navigation));
                    });
                }
            }
        };
    }

    public String getOrderByType() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"desc");
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        sortingURL.setParameter("cur", "0");
        sortingURL.setParameter("orderByCol", "date");
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        final String navigation = this._getNavigation();
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setHref(PortletURLUtil.clone((PortletURL)NotificationsManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)NotificationsManagementToolbarDisplayContext.this._liferayPortletResponse), new Object[]{"cur", "0", "navigation", "all"});
                    dropdownItem.setActive(navigation.equals("all"));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"all"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setHref(PortletURLUtil.clone((PortletURL)NotificationsManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)NotificationsManagementToolbarDisplayContext.this._liferayPortletResponse), new Object[]{"cur", "0", "navigation", "unread"});
                    dropdownItem.setActive(navigation.equals("unread"));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"unread"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setHref(PortletURLUtil.clone((PortletURL)NotificationsManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)NotificationsManagementToolbarDisplayContext.this._liferayPortletResponse), new Object[]{"cur", "0", "navigation", "read"});
                    dropdownItem.setActive(navigation.equals("read"));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"read"));
                });
            }
        };
    }

    private String _getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"all");
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)NotificationsManagementToolbarDisplayContext.this.getSortingURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)NotificationsManagementToolbarDisplayContext.this._httpServletRequest, (String)"date"));
                });
            }
        };
    }

    private boolean _isActionRequired() {
        return ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"actionRequired");
    }
}

