/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.web.internal.upgrade.v2_1_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeUserNotificationEvent
extends UpgradeProcess {
    private final UserNotificationEventLocalService _userNotificationEventLocalService;

    public UpgradeUserNotificationEvent(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (this.hasTable("Notifications_UserNotificationEvent")) {
            this.updateUserNotificationEventActionRequired();
        }
        this.updateUserNotificationEvents();
    }

    protected void updateUserNotificationEventActionRequired() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(5);
            sb.append("update UserNotificationEvent set actionRequired = ");
            sb.append("TRUE where userNotificationEventId in (select ");
            sb.append("userNotificationEventId from ");
            sb.append("Notifications_UserNotificationEvent where ");
            sb.append("actionRequired = TRUE)");
            this.runSQL(sb.toString());
            this.runSQL("update UserNotificationEvent set actionRequired = FALSE where actionRequired IS NULL");
        }
    }

    protected void updateUserNotificationEvents() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select userNotificationEventId, payload, actionRequired from UserNotificationEvent where payload like '%actionRequired%'");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update UserNotificationEvent set payload = ?, actionRequired = ? where userNotificationEventId = ?");
             ResultSet rs = ps1.executeQuery();){
            this.runSQL("update UserNotificationEvent set delivered = TRUE");
            this.runSQL(StringBundler.concat((String[])new String[]{"update UserNotificationEvent set deliveryType = ", String.valueOf(10002), " where deliveryType = 0 or deliveryType is null"}));
            while (rs.next()) {
                long userNotificationEventId = rs.getLong("userNotificationEventId");
                String payload = rs.getString("payload");
                boolean actionRequired = rs.getBoolean("actionRequired");
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)payload);
                jsonObject.remove("actionRequired");
                ps2.setString(1, jsonObject.toString());
                ps2.setBoolean(2, actionRequired |= jsonObject.getBoolean("actionRequired"));
                ps2.setLong(3, userNotificationEventId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

