/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.rest.dto.v1_0.util;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.rest.dto.v1_0.NotificationTemplate;
import com.liferay.notification.service.NotificationRecipientLocalServiceUtil;
import com.liferay.notification.service.NotificationTemplateLocalServiceUtil;
import com.liferay.notification.type.NotificationType;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.List;

public class NotificationUtil {
    public static NotificationContext toNotificationContext(NotificationTemplate notificationTemplate) throws Exception {
        NotificationContext notificationContext = new NotificationContext();
        notificationContext.setAttachmentObjectFieldIds(ListUtil.fromArray((Object[])notificationTemplate.getAttachmentObjectFieldIds()));
        notificationContext.setType(notificationTemplate.getType());
        return notificationContext;
    }

    public static NotificationRecipient toNotificationRecipient(User user, long classPK) {
        NotificationRecipient notificationRecipient = NotificationRecipientLocalServiceUtil.getNotificationRecipientByClassPK((long)classPK);
        if (notificationRecipient != null) {
            return notificationRecipient;
        }
        notificationRecipient = NotificationRecipientLocalServiceUtil.createNotificationRecipient((long)CounterLocalServiceUtil.increment());
        notificationRecipient.setCompanyId(user.getCompanyId());
        notificationRecipient.setUserId(user.getUserId());
        notificationRecipient.setUserName(user.getFullName());
        notificationRecipient.setClassPK(classPK);
        return notificationRecipient;
    }

    public static List<NotificationRecipientSetting> toNotificationRecipientSetting(long notificationRecipientId, NotificationType notificationType, Object[] recipients, User user) {
        return notificationType.createNotificationRecipientSettings(notificationRecipientId, recipients, user);
    }

    public static com.liferay.notification.model.NotificationTemplate toNotificationTemplate(long notificationTemplateId, NotificationTemplate notificationTemplate, User user) {
        com.liferay.notification.model.NotificationTemplate serviceBuilderNotificationTemplate = NotificationTemplateLocalServiceUtil.fetchNotificationTemplate((long)notificationTemplateId);
        if (serviceBuilderNotificationTemplate == null) {
            serviceBuilderNotificationTemplate = NotificationTemplateLocalServiceUtil.createNotificationTemplate((long)0L);
        }
        serviceBuilderNotificationTemplate.setCompanyId(user.getCompanyId());
        serviceBuilderNotificationTemplate.setUserId(user.getUserId());
        serviceBuilderNotificationTemplate.setUserName(user.getFullName());
        serviceBuilderNotificationTemplate.setObjectDefinitionId(GetterUtil.getLong((Object)notificationTemplate.getObjectDefinitionId()));
        serviceBuilderNotificationTemplate.setBodyMap(LocalizedMapUtil.getLocalizedMap(notificationTemplate.getBody()));
        serviceBuilderNotificationTemplate.setDescription(notificationTemplate.getDescription());
        serviceBuilderNotificationTemplate.setEditorType(GetterUtil.getString((String)notificationTemplate.getEditorTypeAsString(), (String)"richText"));
        serviceBuilderNotificationTemplate.setName(notificationTemplate.getName());
        serviceBuilderNotificationTemplate.setRecipientType(notificationTemplate.getRecipientType());
        serviceBuilderNotificationTemplate.setSubjectMap(LocalizedMapUtil.getLocalizedMap(notificationTemplate.getSubject()));
        serviceBuilderNotificationTemplate.setType(notificationTemplate.getType());
        return serviceBuilderNotificationTemplate;
    }
}

