/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.normalizer.internal;

import com.liferay.ibm.icu.text.Transliterator;
import com.liferay.normalizer.Normalizer;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={Normalizer.class})
public class NormalizerImpl
implements Normalizer {
    private static final String[] _NORMALIZED_TEXT = new String[]{"l", "'", "\""};
    private static final String[] _UNICODE_TEXT = new String[]{"\u0142", "\u02b9", "\u02ba"};

    public String normalizeToAscii(String s) {
        if (!this._hasNonasciiCode(s)) {
            return s;
        }
        String normalizedText = TransliteratorHolder.transform(s);
        return StringUtil.replace((String)normalizedText, (String[])_UNICODE_TEXT, (String[])_NORMALIZED_TEXT);
    }

    private boolean _hasNonasciiCode(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private static class TransliteratorHolder {
        private static final Transliterator _transliterator = Transliterator.getInstance((String)"Greek-Latin; Cyrillic-Latin; NFD; [:Nonspacing Mark:] Remove; NFC");

        private TransliteratorHolder() {
        }

        public static String transform(String source) {
            return _transliterator.transform(source);
        }
    }
}

