/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.network.utilities.web.internal.util;

import com.liferay.network.utilities.web.internal.model.DNSLookup;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import java.net.InetAddress;

public class DNSLookupWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 86400000L;
    private final String _domain;

    public DNSLookupWebCacheItem(String domain) {
        this._domain = domain;
    }

    public Object convert(String key) throws WebCacheException {
        DNSLookup dnsLookup = null;
        try {
            char[] array;
            String results = null;
            String trimmedDomain = this._domain.trim();
            for (char c : array = trimmedDomain.toCharArray()) {
                if (c == '.' || Character.isDigit(c)) continue;
                InetAddress inetAddress = InetAddress.getByName(this._domain);
                results = inetAddress.getHostAddress();
                break;
            }
            if (results == null) {
                InetAddress[] inetAddresses = InetAddress.getAllByName(this._domain);
                if (inetAddresses.length == 0) {
                    results = "";
                } else {
                    StringBundler sb = new StringBundler(inetAddresses.length * 2 - 1);
                    for (int i = 0; i < inetAddresses.length; ++i) {
                        sb.append(inetAddresses[i].getHostName());
                        if (i + 1 > inetAddresses.length) continue;
                        sb.append(",");
                    }
                    results = sb.toString();
                }
            }
            dnsLookup = new DNSLookup(this._domain, results);
        }
        catch (Exception e) {
            throw new WebCacheException(this._domain + " " + e.toString());
        }
        return dnsLookup;
    }

    public long getRefreshTime() {
        return 86400000L;
    }
}

