/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nested.portlets.web.internal.portlet;

import com.liferay.nested.portlets.web.internal.display.context.NestedPortletsDisplayContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutTemplateLocalService;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-nested-portlets", "com.liferay.portlet.display-category=category.cms", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.layout-cacheable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=1", "com.liferay.portlet.single-page-application=false", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Nested Portlets", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=guest,power-user,user"}, service={Portlet.class})
public class NestedPortletsPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(NestedPortletsPortlet.class);
    private static final Pattern _columnIdPattern = Pattern.compile("([<].*?id=[\"'])([^ ]*?)([\"'].*?[>])", 32);
    private static final Pattern _processColumnPattern = Pattern.compile("(processColumn[(]\")(.*?)(\"(?:, *\"(?:.*?)\")?[)])", 32);
    private LayoutLocalService _layoutLocalService;
    private LayoutTemplateLocalService _layoutTemplateLocalService;
    @Reference
    private Portal _portal;

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String layoutTemplateId;
        ThemeDisplay themeDisplay;
        block6: {
            themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            layoutTemplateId = "";
            try {
                NestedPortletsDisplayContext nestedPortletsDisplayContext = new NestedPortletsDisplayContext(this._portal.getHttpServletRequest((PortletRequest)renderRequest));
                layoutTemplateId = nestedPortletsDisplayContext.getLayoutTemplateId();
            }
            catch (ConfigurationException ce) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)ce, (Throwable)ce);
            }
        }
        String templateId = "";
        String templateContent = "";
        HashMap<String, String> columnIds = new HashMap<String, String>();
        if (Validator.isNotNull((String)layoutTemplateId)) {
            Theme theme = themeDisplay.getTheme();
            LayoutTemplate layoutTemplate = this._layoutTemplateLocalService.getLayoutTemplate(layoutTemplateId, false, theme.getThemeId());
            String content = layoutTemplate.getContent();
            Matcher processColumnMatcher = _processColumnPattern.matcher(content);
            while (processColumnMatcher.find()) {
                String columnId = processColumnMatcher.group(2);
                if (!Validator.isNotNull((String)columnId)) continue;
                columnIds.put(columnId, renderResponse.getNamespace() + "_" + columnId);
            }
            processColumnMatcher.reset();
            StringBundler sb = new StringBundler(4);
            sb.append(theme.getThemeId());
            sb.append("_CUSTOM_");
            sb.append(renderResponse.getNamespace());
            sb.append(layoutTemplateId);
            templateId = sb.toString();
            content = processColumnMatcher.replaceAll("$1" + renderResponse.getNamespace() + "_$2$3");
            Matcher columnIdMatcher = _columnIdPattern.matcher(content);
            templateContent = columnIdMatcher.replaceAll("$1" + renderResponse.getNamespace() + "_$2$3");
        }
        this.checkLayout(themeDisplay.getLayout(), columnIds.values());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        renderRequest.setAttribute("TEMPLATE_ID" + portletDisplay.getId(), (Object)templateId);
        renderRequest.setAttribute("TEMPLATE_CONTENT" + portletDisplay.getId(), (Object)templateContent);
        Map vmVariables = (Map)renderRequest.getAttribute("FTL_VARIABLES" + portletDisplay.getId());
        if (vmVariables != null) {
            vmVariables.putAll(columnIds);
        } else {
            renderRequest.setAttribute("FTL_VARIABLES" + portletDisplay.getId(), columnIds);
        }
        super.include(this.viewTemplate, renderRequest, renderResponse);
    }

    protected void checkLayout(Layout layout, Collection<String> columnIds) {
        block4: {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            Object[] layoutColumnIds = StringUtil.split((String)((String)typeSettingsProperties.get((Object)"nested-column-ids")));
            boolean updateColumnIds = false;
            for (String columnId : columnIds) {
                String portletIds = typeSettingsProperties.getProperty(columnId);
                if (!Validator.isNotNull((String)portletIds) || ArrayUtil.contains((Object[])layoutColumnIds, (Object)columnId)) continue;
                layoutColumnIds = (String[])ArrayUtil.append((Object[])layoutColumnIds, (Object)columnId);
                updateColumnIds = true;
            }
            if (updateColumnIds) {
                typeSettingsProperties.setProperty("nested-column-ids", StringUtil.merge((Object[])layoutColumnIds));
                layout.setTypeSettingsProperties(typeSettingsProperties);
                try {
                    this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutTemplateLocalService(LayoutTemplateLocalService layoutTemplateLocalService) {
        this._layoutTemplateLocalService = layoutTemplateLocalService;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.nested.portlets.web)(&(release.schema.version>=1.0.0)(!(release.schema.version>=1.1.0))))", unbind="-")
    protected void setRelease(Release release) {
    }
}

