/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nested.portlets.web.internal.display.context;

import com.liferay.nested.portlets.web.configuration.NestedPortletsPortletInstanceConfiguration;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginUtil;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class NestedPortletsDisplayContext {
    private final HttpServletRequest _httpServletRequest;
    private String _layoutTemplateId;
    private final NestedPortletsPortletInstanceConfiguration _nestedPortletsPortletInstanceConfiguration;

    public NestedPortletsDisplayContext(HttpServletRequest httpServletRequest) throws ConfigurationException {
        this._httpServletRequest = httpServletRequest;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._nestedPortletsPortletInstanceConfiguration = (NestedPortletsPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(NestedPortletsPortletInstanceConfiguration.class);
    }

    public HttpServletRequest getLastForwardRequest() {
        HttpServletRequest currentHttpServletRequest = this._httpServletRequest;
        PersistentHttpServletRequestWrapper currentRequestWrapper = null;
        PersistentHttpServletRequestWrapper originalHttpServletRequest = null;
        HttpServletRequest nextHttpServletRequest = null;
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper) {
            if (currentHttpServletRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentHttpServletRequest;
                persistentHttpServletRequestWrapper = persistentHttpServletRequestWrapper.clone();
                if (originalHttpServletRequest == null) {
                    originalHttpServletRequest = persistentHttpServletRequestWrapper.clone();
                }
                if (currentRequestWrapper != null) {
                    currentRequestWrapper.setRequest((ServletRequest)persistentHttpServletRequestWrapper);
                }
                currentRequestWrapper = persistentHttpServletRequestWrapper;
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            nextHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            if (currentHttpServletRequest.getDispatcherType() == DispatcherType.FORWARD && nextHttpServletRequest.getDispatcherType() == DispatcherType.REQUEST) break;
            currentHttpServletRequest = nextHttpServletRequest;
        }
        if (currentRequestWrapper != null && !this._isVirtualHostRequest(nextHttpServletRequest)) {
            currentRequestWrapper.setRequest((ServletRequest)currentHttpServletRequest);
        }
        if (originalHttpServletRequest != null) {
            return originalHttpServletRequest;
        }
        return currentHttpServletRequest;
    }

    public String getLayoutTemplateId() {
        if (this._layoutTemplateId != null) {
            return this._layoutTemplateId;
        }
        this._layoutTemplateId = this._nestedPortletsPortletInstanceConfiguration.layoutTemplateId();
        return this._layoutTemplateId;
    }

    public List<LayoutTemplate> getLayoutTemplates() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List layoutTemplates = LayoutTemplateLocalServiceUtil.getLayoutTemplates((String)themeDisplay.getThemeId());
        layoutTemplates = PluginUtil.restrictPlugins((List)layoutTemplates, (User)themeDisplay.getUser());
        List<String> unSupportedLayoutTemplateIds = this.getUnsupportedLayoutTemplateIds();
        return ListUtil.filter((List)layoutTemplates, layoutTemplate -> !unSupportedLayoutTemplateIds.contains(layoutTemplate.getLayoutTemplateId()));
    }

    protected List<String> getUnsupportedLayoutTemplateIds() {
        return ListUtil.fromArray((Object[])this._nestedPortletsPortletInstanceConfiguration.layoutTemplatesUnsupported());
    }

    private boolean _isVirtualHostRequest(HttpServletRequest httpServletRequest) {
        LayoutSet layoutSet = (LayoutSet)httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        return layoutSet != null && Validator.isNotNull((String)layoutSet.getVirtualHostname());
    }
}

