/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nested.portlets.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutTemplateLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet"}, service={ConfigurationAction.class})
public class NestedPortletsConfigurationAction
extends DefaultConfigurationAction {
    private static final Pattern _pattern = Pattern.compile("processColumn[(]\"(.*?)\"(?:, *\"(?:.*?)\")?[)]", 32);
    private LayoutLocalService _layoutLocalService;
    private LayoutTemplateLocalService _layoutTemplateLocalService;
    @Reference
    private Portal _portal;

    public String getJspPath(HttpServletRequest request) {
        return "/configuration.jsp";
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String layoutTemplateId = this.getParameter((PortletRequest)actionRequest, "layoutTemplateId");
        String oldLayoutTemplateId = ParamUtil.getString((PortletRequest)actionRequest, (String)"oldLayoutTemplateId");
        if (!oldLayoutTemplateId.equals(layoutTemplateId)) {
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            this.reorganizeNestedColumns(actionRequest, portletResource, layoutTemplateId, oldLayoutTemplateId);
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.nested.portlets.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected List<String> getColumnNames(String content, String portletId) {
        Matcher matcher = _pattern.matcher(content);
        HashSet<String> columnIds = new HashSet<String>();
        while (matcher.find()) {
            if (!Validator.isNotNull((String)matcher.group(1))) continue;
            columnIds.add(matcher.group(1));
        }
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>();
        for (String columnId : columnIds) {
            if (columnId.contains(portletId)) continue;
            columnNames.add(this._portal.getPortletNamespace(portletId) + "_" + columnId);
        }
        return new ArrayList<String>(columnNames);
    }

    protected void reorganizeNestedColumns(ActionRequest actionRequest, String portletResource, String newLayoutTemplateId, String oldLayoutTemplateId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        Theme theme = themeDisplay.getTheme();
        LayoutTemplate newLayoutTemplate = this._layoutTemplateLocalService.getLayoutTemplate(newLayoutTemplateId, false, theme.getThemeId());
        List<String> newColumns = this.getColumnNames(newLayoutTemplate.getContent(), portletResource);
        LayoutTemplate oldLayoutTemplate = this._layoutTemplateLocalService.getLayoutTemplate(oldLayoutTemplateId, false, theme.getThemeId());
        List<String> oldColumns = this.getColumnNames(oldLayoutTemplate.getContent(), portletResource);
        layoutTypePortlet.reorganizePortlets(newColumns, oldColumns);
        layoutTypePortlet.setStateMax("");
        this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutTemplateLocalService(LayoutTemplateLocalService layoutTemplateLocalService) {
        this._layoutTemplateLocalService = layoutTemplateLocalService;
    }
}

