/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nested.portlets.web.internal.display.context;

import com.liferay.nested.portlets.web.configuration.NestedPortletsPortletInstanceConfiguration;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginUtil;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class NestedPortletsDisplayContext {
    private String _layoutTemplateId;
    private final NestedPortletsPortletInstanceConfiguration _nestedPortletsPortletInstanceConfiguration;
    private final HttpServletRequest _request;

    public NestedPortletsDisplayContext(HttpServletRequest request) throws ConfigurationException {
        this._request = request;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._nestedPortletsPortletInstanceConfiguration = (NestedPortletsPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(NestedPortletsPortletInstanceConfiguration.class);
    }

    public HttpServletRequest getLastForwardRequest() {
        HttpServletRequest currentRequest = this._request;
        PersistentHttpServletRequestWrapper currentRequestWrapper = null;
        PersistentHttpServletRequestWrapper originalRequest = null;
        HttpServletRequest nextRequest = null;
        while (currentRequest instanceof HttpServletRequestWrapper) {
            if (currentRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentRequest;
                persistentHttpServletRequestWrapper = persistentHttpServletRequestWrapper.clone();
                if (originalRequest == null) {
                    originalRequest = persistentHttpServletRequestWrapper.clone();
                }
                if (currentRequestWrapper != null) {
                    currentRequestWrapper.setRequest((ServletRequest)persistentHttpServletRequestWrapper);
                }
                currentRequestWrapper = persistentHttpServletRequestWrapper;
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentRequest;
            nextRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            if (currentRequest.getDispatcherType() == DispatcherType.FORWARD && nextRequest.getDispatcherType() == DispatcherType.REQUEST) break;
            currentRequest = nextRequest;
        }
        if (currentRequestWrapper != null && !this._isVirtualHostRequest(nextRequest)) {
            currentRequestWrapper.setRequest((ServletRequest)currentRequest);
        }
        if (originalRequest != null) {
            return originalRequest;
        }
        return currentRequest;
    }

    public String getLayoutTemplateId() {
        if (this._layoutTemplateId != null) {
            return this._layoutTemplateId;
        }
        this._layoutTemplateId = this._nestedPortletsPortletInstanceConfiguration.layoutTemplateId();
        return this._layoutTemplateId;
    }

    public List<LayoutTemplate> getLayoutTemplates() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List layoutTemplates = LayoutTemplateLocalServiceUtil.getLayoutTemplates((String)themeDisplay.getThemeId());
        layoutTemplates = PluginUtil.restrictPlugins((List)layoutTemplates, (User)themeDisplay.getUser());
        final List<String> unSupportedLayoutTemplateIds = this.getUnsupportedLayoutTemplateIds();
        return ListUtil.filter((List)layoutTemplates, (PredicateFilter)new PredicateFilter<LayoutTemplate>(){

            public boolean filter(LayoutTemplate layoutTemplate) {
                return !unSupportedLayoutTemplateIds.contains(layoutTemplate.getLayoutTemplateId());
            }
        });
    }

    protected List<String> getUnsupportedLayoutTemplateIds() {
        return ListUtil.fromArray((Object[])this._nestedPortletsPortletInstanceConfiguration.layoutTemplatesUnsupported());
    }

    private boolean _isVirtualHostRequest(HttpServletRequest request) {
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        return layoutSet != null && Validator.isNotNull((String)layoutSet.getVirtualHostname());
    }
}

