/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.my.subscriptions.web.internal.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.journal.model.JournalFolder;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBThreadLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeLocalServiceUtil;
import java.util.Locale;
import javax.portlet.PortletPreferences;

public class MySubscriptionsUtil {
    private static final String _BLOGS_ENTRY_CLASSNAME = "com.liferay.blogs.kernel.model.BlogsEntry";
    private static final String _KNOWLEDGE_BASE_DISPLAY_PORTLET_ID = "com_liferay_knowledge_base_web_portlet_DisplayPortlet";
    private static final String _KNOWLEDGE_BASE_MODEL_CLASSNAME = "com.liferay.knowledge.base.model.KBArticle";

    public static AssetRenderer getAssetRenderer(String className, long classPK) {
        try {
            return MySubscriptionsUtil.doGetAssetRenderer(className, classPK);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getAssetURLViewInContext(ThemeDisplay themeDisplay, String className, long classPK) throws PortalException {
        if (className.equals(_BLOGS_ENTRY_CLASSNAME)) {
            return PortalUtil.getLayoutFullURL((long)classPK, (String)"com_liferay_blogs_web_portlet_BlogsPortlet");
        }
        if (className.equals(Folder.class.getName())) {
            return PortalUtil.getLayoutFullURL((long)classPK, (String)"com_liferay_document_library_web_portlet_DLPortlet");
        }
        if (className.equals(_KNOWLEDGE_BASE_MODEL_CLASSNAME)) {
            return PortalUtil.getLayoutFullURL((long)classPK, (String)_KNOWLEDGE_BASE_DISPLAY_PORTLET_ID);
        }
        if (className.equals(Layout.class.getName())) {
            return PortalUtil.getLayoutFullURL((Layout)LayoutLocalServiceUtil.getLayout((long)classPK), (ThemeDisplay)themeDisplay);
        }
        if (className.equals(MBCategory.class.getName())) {
            String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            return PortalUtil.getLayoutFullURL((long)classPK, (String)portletId);
        }
        if (className.equals(WikiNode.class.getName())) {
            long plid = PortalUtil.getPlidFromPortletId((long)themeDisplay.getScopeGroupId(), (String)"com_liferay_wiki_web_portlet_WikiPortlet");
            if (plid == 0L) {
                return null;
            }
            StringBundler sb = new StringBundler(5);
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)themeDisplay);
            sb.append(layoutFullURL);
            sb.append("/-/");
            sb.append("wiki/");
            sb.append(classPK);
            sb.append("/all_pages");
            return sb.toString();
        }
        return null;
    }

    public static String getTitleText(Locale locale, String className, long classPK, String title) throws PortalException {
        if (Validator.isNotNull((String)title)) {
            return title;
        }
        Group group = GroupLocalServiceUtil.fetchGroup((long)classPK);
        if (className.equals(BlogsEntry.class.getName()) || className.equals(_BLOGS_ENTRY_CLASSNAME)) {
            title = "Blog at ";
        } else if (className.equals(BookmarksFolder.class.getName())) {
            if (group != null) {
                return LanguageUtil.get((Locale)locale, (String)"home");
            }
        } else {
            if (className.equals(DLFileEntryType.class.getName())) {
                if (group != null) {
                    return LanguageUtil.get((Locale)locale, (String)"basic-document");
                }
                DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getDLFileEntryType((long)classPK);
                return dlFileEntryType.getName(locale);
            }
            if (className.equals(DLFolderConstants.getClassName()) || className.equals(Folder.class.getName())) {
                if (group != null) {
                    return LanguageUtil.get((Locale)locale, (String)"home");
                }
            } else if (className.equals(JournalFolder.class.getName())) {
                if (group != null) {
                    return LanguageUtil.get((Locale)locale, (String)"home");
                }
            } else if (className.equals(_KNOWLEDGE_BASE_MODEL_CLASSNAME)) {
                title = "Knowledge Base Article at ";
            } else {
                if (className.equals(Layout.class.getName())) {
                    Layout layout = LayoutLocalServiceUtil.getLayout((long)classPK);
                    return layout.getName(locale);
                }
                if (className.equals(MBCategory.class.getName())) {
                    title = "Message Board at ";
                } else {
                    if (className.equals(com.liferay.portal.kernel.model.PortletPreferences.class.getName())) {
                        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)classPK);
                        Layout layout = LayoutLocalServiceUtil.getLayout((long)portletPreferences.getPlid());
                        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletPreferences.getPortletId(), null);
                        String portletTitle = jxPortletPreferences.getValue("portletSetupTitle_" + LocaleUtil.toLanguageId((Locale)locale), "");
                        if (Validator.isNull((String)portletTitle)) {
                            portletTitle = "Asset Publisher";
                        }
                        return portletTitle;
                    }
                    if (className.equals(WikiNode.class.getName())) {
                        WikiNode wikiNode = WikiNodeLocalServiceUtil.getWikiNode((long)classPK);
                        return wikiNode.getName();
                    }
                }
            }
        }
        if (group != null) {
            title = title + group.getDescriptiveName(locale);
        }
        if (Validator.isNull((String)title)) {
            title = String.valueOf(classPK);
        }
        return title;
    }

    protected static AssetRenderer doGetAssetRenderer(String className, long classPK) throws Exception {
        if (className.equals(Folder.class.getName())) {
            className = DLFolder.class.getName();
        } else if (className.equals(MBThread.class.getName())) {
            className = MBMessage.class.getName();
            MBThread mbThread = MBThreadLocalServiceUtil.getThread((long)classPK);
            classPK = mbThread.getRootMessageId();
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        return assetRendererFactory.getAssetRenderer(classPK);
    }
}

