/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.monitoring.web.internal.portlet.action;

import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_monitoring_web_portlet_MonitoringPortlet", "mvc.command.name=/monitoring/edit_session"}, service={MVCActionCommand.class})
public class EditSessionMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditSessionMVCActionCommand.class);
    private static final MethodKey _invalidateSessionMethodKey = new MethodKey(EditSessionMVCActionCommand.class, "_invalidateSession", new Class[]{String.class});
    @Reference
    private ClusterExecutor _clusterExecutor;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.MustBeCompanyAdmin.class.getName());
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        this.invalidateSession(actionRequest);
        this.sendRedirect(actionRequest, actionResponse);
    }

    protected void invalidateSession(ActionRequest actionRequest) throws Exception {
        String sessionId = ParamUtil.getString((PortletRequest)actionRequest, (String)"sessionId");
        try {
            PortletSession portletSession = actionRequest.getPortletSession();
            String portletSessionId = portletSession.getId();
            if (!portletSessionId.equals(sessionId)) {
                HttpSession userSession = PortalSessionContext.get((String)sessionId);
                if (userSession != null) {
                    userSession.invalidate();
                    return;
                }
                if (!this._clusterExecutor.isEnabled()) {
                    return;
                }
                try {
                    MethodHandler methodHandler = new MethodHandler(_invalidateSessionMethodKey, new Object[]{sessionId});
                    ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
                    clusterRequest.setFireAndForget(true);
                    this._clusterExecutor.execute(clusterRequest);
                }
                catch (Throwable t) {
                    _log.error((Object)"Unable to notify cluster ", t);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to invalidate session", (Throwable)e);
        }
    }

    private static void _invalidateSession(String sessionId) {
        HttpSession userSession = PortalSessionContext.get((String)sessionId);
        if (userSession != null) {
            boolean eanbled = ClusterInvokeThreadLocal.isEnabled();
            ClusterInvokeThreadLocal.setEnabled((boolean)true);
            try {
                userSession.invalidate();
            }
            finally {
                ClusterInvokeThreadLocal.setEnabled((boolean)eanbled);
            }
        }
    }
}

