/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.rule.group.action;

import com.liferay.mobile.device.rules.action.ActionHandler;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.mobile.device.rules.web.internal.rule.group.action.BaseRedirectActionHandler;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ActionHandler.class})
public class SiteRedirectActionHandler
extends BaseRedirectActionHandler {
    private static final Log _log = LogFactoryUtil.getLog(SiteRedirectActionHandler.class);
    private static final Collection<String> _propertyNames = Collections.unmodifiableCollection(Arrays.asList("groupId", "plid"));
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public static String getHandlerType() {
        return SiteRedirectActionHandler.class.getName();
    }

    public String getEditorJSP() {
        return "/action/site_url.jsp";
    }

    public Collection<String> getPropertyNames() {
        return _propertyNames;
    }

    public String getType() {
        return SiteRedirectActionHandler.getHandlerType();
    }

    @Override
    protected String getURL(MDRAction mdrAction, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        ThemeDisplay themeDisplay;
        Layout themeDisplayLayout;
        UnicodeProperties typeSettingsProperties = mdrAction.getTypeSettingsProperties();
        long plid = GetterUtil.getLong((String)typeSettingsProperties.getProperty("plid"));
        if (plid == (themeDisplayLayout = (themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")).getLayout()).getPlid()) {
            return null;
        }
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        long groupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("groupId"));
        if (layout != null && layout.getGroupId() != groupId) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Layout ", layout.getPlid(), " does not belong to group ", groupId}));
            }
            layout = null;
        }
        if (layout == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using default public layout");
            }
            Group group = null;
            if (groupId != themeDisplayLayout.getGroupId()) {
                group = this._groupLocalService.fetchGroup(groupId);
            }
            if (group == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No group found with group ID " + groupId));
                }
                return null;
            }
            layout = this._layoutLocalService.fetchLayout(group.getDefaultPublicPlid());
        }
        if (layout != null) {
            return this._portal.getLayoutURL(layout, themeDisplay);
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to resolve default layout");
        }
        return null;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

