/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.portlet.action;

import com.liferay.mobile.device.rules.action.ActionHandler;
import com.liferay.mobile.device.rules.action.ActionHandlerManagerUtil;
import com.liferay.mobile.device.rules.exception.ActionTypeException;
import com.liferay.mobile.device.rules.exception.NoSuchActionException;
import com.liferay.mobile.device.rules.exception.NoSuchRuleGroupException;
import com.liferay.mobile.device.rules.service.MDRActionService;
import com.liferay.mobile.device.rules.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mobile_device_rules_web_portlet_MDRPortlet", "mvc.command.name=/mobile_device_rules/edit_action"}, service={MVCActionCommand.class})
public class EditActionMVCActionCommand
extends BaseMVCActionCommand {
    private MDRActionService _mdrActionService;

    protected void deleteActions(ActionRequest actionRequest) throws Exception {
        long[] deleteActionIds = null;
        long actionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"actionId");
        deleteActionIds = actionId > 0L ? new long[]{actionId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        for (long deleteActionId : deleteActionIds) {
            this._mdrActionService.deleteAction(deleteActionId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateAction(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteActions(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof ActionTypeException || e instanceof NoSuchActionException || e instanceof NoSuchRuleGroupException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setMDRActionService(MDRActionService mdrActionService) {
        this._mdrActionService = mdrActionService;
    }

    protected void updateAction(ActionRequest actionRequest) throws Exception {
        long actionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"actionId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        ActionHandler actionHandler = ActionHandlerManagerUtil.getActionHandler((String)type);
        if (actionHandler == null) {
            throw new ActionTypeException();
        }
        UnicodeProperties typeSettingsProperties = ActionUtil.getTypeSettingsProperties(actionRequest, actionHandler.getPropertyNames());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (actionId <= 0L) {
            long ruleGroupInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupInstanceId");
            this._mdrActionService.addAction(ruleGroupInstanceId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
        } else {
            this._mdrActionService.updateAction(actionId, nameMap, descriptionMap, type, typeSettingsProperties, serviceContext);
        }
    }
}

