/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.portlet.action;

import com.liferay.mobile.device.rules.exception.NoSuchRuleGroupException;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mobile_device_rules_web_portlet_MDRPortlet", "mvc.command.name=/mobile_device_rules/edit_rule_group_instance"}, service={MVCActionCommand.class})
public class EditRuleGroupInstanceMVCActionCommand
extends BaseMVCActionCommand {
    private MDRRuleGroupInstanceService _mdrRuleGroupInstanceService;
    @Reference
    private Portal _portal;

    protected void deleteRuleGroupInstance(ActionRequest actionRequest) throws PortalException {
        long ruleGroupInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupInstanceId");
        this._mdrRuleGroupInstanceService.deleteRuleGroupInstance(ruleGroupInstanceId);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteRuleGroupInstance(actionRequest);
            } else if (cmd.equals("update")) {
                this.updateRuleGroupInstancesPriorities(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse, this.getRedirect(actionRequest, actionResponse));
        }
        catch (Exception e) {
            if (e instanceof NoSuchRuleGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse) {
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/mobile_device_rules/edit_rule_group_instance");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        portletURL.setParameter("redirect", redirect);
        return portletURL.toString();
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupInstanceService(MDRRuleGroupInstanceService mdrRuleGroupInstanceService) {
        this._mdrRuleGroupInstanceService = mdrRuleGroupInstanceService;
    }

    protected void updateRuleGroupInstancesPriorities(ActionRequest actionRequest) throws PortalException {
        String ruleGroupsInstancesJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"ruleGroupsInstancesJSON");
        JSONArray ruleGroupsInstancesJSONArray = JSONFactoryUtil.createJSONArray((String)ruleGroupsInstancesJSON);
        for (int i = 0; i < ruleGroupsInstancesJSONArray.length(); ++i) {
            JSONObject ruleGroupInstanceJSONObject = ruleGroupsInstancesJSONArray.getJSONObject(i);
            long ruleGroupInstanceId = ruleGroupInstanceJSONObject.getLong("ruleGroupInstanceId");
            int priority = ruleGroupInstanceJSONObject.getInt("priority");
            this._mdrRuleGroupInstanceService.updateRuleGroupInstance(ruleGroupInstanceId, priority);
        }
    }
}

