/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.MDRActionLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalService;
import com.liferay.mobile.device.rules.web.internal.rule.group.action.SiteRedirectActionHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MDRActionStagedModelDataHandler
extends BaseStagedModelDataHandler<MDRAction> {
    public static final String[] CLASS_NAMES = new String[]{MDRAction.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(MDRActionStagedModelDataHandler.class);
    private LayoutLocalService _layoutLocalService;
    private MDRActionLocalService _mdrActionLocalService;
    private MDRRuleGroupInstanceLocalService _mdrRuleGroupInstanceLocalService;

    public void deleteStagedModel(MDRAction action) {
        this._mdrActionLocalService.deleteAction(action);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MDRAction action = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (action != null) {
            this.deleteStagedModel(action);
        }
    }

    public MDRAction fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mdrActionLocalService.fetchMDRActionByUuidAndGroupId(uuid, groupId);
    }

    public List<MDRAction> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mdrActionLocalService.getMDRActionsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MDRAction action) {
        return action.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MDRAction action) throws Exception {
        Element actionElement;
        block3: {
            MDRRuleGroupInstance ruleGroupInstance = this._mdrRuleGroupInstanceLocalService.getRuleGroupInstance(action.getRuleGroupInstanceId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)action, (StagedModel)ruleGroupInstance, (String)"parent");
            actionElement = portletDataContext.getExportDataElement((ClassedModel)action);
            String type = action.getType();
            if (type.equals(SiteRedirectActionHandler.class.getName())) {
                UnicodeProperties typeSettingsProperties = action.getTypeSettingsProperties();
                long plid = GetterUtil.getLong((String)typeSettingsProperties.getProperty("plid"));
                try {
                    Layout layout = this._layoutLocalService.getLayout(plid);
                    actionElement.addAttribute("layout-uuid", layout.getUuid());
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to set the layout uuid of layout " + plid + ". Site redirect may not match after import."), (Throwable)e);
                }
            }
        }
        portletDataContext.addClassedModel(actionElement, ExportImportPathUtil.getModelPath((StagedModel)action), (ClassedModel)action);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MDRAction action) throws Exception {
        Map ruleGroupInstanceIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroupInstance.class);
        long ruleGroupInstanceId = MapUtil.getLong((Map)ruleGroupInstanceIds, (long)action.getRuleGroupInstanceId(), (long)action.getRuleGroupInstanceId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)action);
        serviceContext.setUserId(portletDataContext.getUserId(action.getUserUuid()));
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)action);
        this.validateLayout(element, action);
        MDRAction importedAction = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRAction existingAction = this.fetchStagedModelByUuidAndGroupId(action.getUuid(), portletDataContext.getScopeGroupId());
            if (existingAction == null) {
                serviceContext.setUuid(action.getUuid());
                importedAction = this._mdrActionLocalService.addAction(ruleGroupInstanceId, action.getNameMap(), action.getDescriptionMap(), action.getType(), action.getTypeSettingsProperties(), serviceContext);
            } else {
                importedAction = this._mdrActionLocalService.updateAction(existingAction.getActionId(), action.getNameMap(), action.getDescriptionMap(), action.getType(), action.getTypeSettingsProperties(), serviceContext);
            }
        } else {
            importedAction = this._mdrActionLocalService.addAction(ruleGroupInstanceId, action.getNameMap(), action.getDescriptionMap(), action.getType(), action.getTypeSettingsProperties(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)action, (ClassedModel)importedAction);
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRActionLocalService(MDRActionLocalService mdrActionLocalService) {
        this._mdrActionLocalService = mdrActionLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupInstanceLocalService(MDRRuleGroupInstanceLocalService mdrRuleGroupInstanceLocalService) {
        this._mdrRuleGroupInstanceLocalService = mdrRuleGroupInstanceLocalService;
    }

    protected void validateLayout(Element actionElement, MDRAction action) {
        block4: {
            String type = action.getType();
            if (!type.equals(SiteRedirectActionHandler.class.getName())) {
                return;
            }
            String layoutUuid = actionElement.attributeValue("layout-uuid");
            if (Validator.isNull((String)layoutUuid)) {
                return;
            }
            UnicodeProperties typeSettingsProperties = action.getTypeSettingsProperties();
            long groupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("groupId"));
            boolean privateLayout = GetterUtil.getBoolean((String)actionElement.attributeValue("private-layout"));
            try {
                Layout layout = this._layoutLocalService.getLayoutByUuidAndGroupId(layoutUuid, groupId, privateLayout);
                typeSettingsProperties.setProperty("plid", String.valueOf(layout.getPlid()));
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                StringBundler sb = new StringBundler(5);
                sb.append("Unable to find layout with uuid ");
                sb.append(layoutUuid);
                sb.append(" in group ");
                sb.append(groupId);
                sb.append(". Site redirect may not match the target layout.");
                _log.warn((Object)sb.toString(), (Throwable)e);
            }
        }
    }
}

