/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.portlet.action;

import com.liferay.mobile.device.rules.exception.NoSuchRuleGroupException;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.MDRRuleGroupService;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_mobile_device_rules_web_portlet_MDRPortlet", "mvc.command.name=/mobile_device_rules/edit_rule_group"}, service={MVCActionCommand.class})
public class EditRuleGroupMVCActionCommand
extends BaseMVCActionCommand {
    private MDRRuleGroupService _mdrRuleGroupService;
    @Reference
    private Portal _portal;

    protected MDRRuleGroup copyRuleGroup(ActionRequest actionRequest) throws Exception {
        long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        return this._mdrRuleGroupService.copyRuleGroup(ruleGroupId, groupId, serviceContext);
    }

    protected void deleteRuleGroups(ActionRequest actionRequest) throws Exception {
        long[] deleteRuleGroupIds = null;
        long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
        deleteRuleGroupIds = ruleGroupId > 0L ? new long[]{ruleGroupId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        for (long deleteRuleGroupId : deleteRuleGroupIds) {
            this._mdrRuleGroupService.deleteRuleGroup(deleteRuleGroupId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRuleGroup(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRuleGroups(actionRequest);
            } else if (cmd.equals("copy")) {
                this.copyRuleGroup(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchRuleGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            throw e;
        }
    }

    protected String getAddOrCopyRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MDRRuleGroup ruleGroup) {
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/mobile_device_rules/edit_rule_group");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("ruleGroupId", String.valueOf(ruleGroup.getRuleGroupId()));
        return portletURL.toString();
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupService(MDRRuleGroupService mdrRuleGroupService) {
        this._mdrRuleGroupService = mdrRuleGroupService;
    }

    protected MDRRuleGroup updateRuleGroup(ActionRequest actionRequest) throws Exception {
        long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        MDRRuleGroup ruleGroup = null;
        if (ruleGroupId <= 0L) {
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            ruleGroup = this._mdrRuleGroupService.addRuleGroup(groupId, nameMap, descriptionMap, serviceContext);
        } else {
            ruleGroup = this._mdrRuleGroupService.updateRuleGroup(ruleGroupId, nameMap, descriptionMap, serviceContext);
        }
        return ruleGroup;
    }
}

