/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.MDRRuleGroupLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MDRRuleGroupStagedModelDataHandler
extends BaseStagedModelDataHandler<MDRRuleGroup> {
    public static final String[] CLASS_NAMES = new String[]{MDRRuleGroup.class.getName()};
    private MDRRuleGroupLocalService _mdrRuleGroupLocalService;

    public void deleteStagedModel(MDRRuleGroup ruleGroup) {
        this._mdrRuleGroupLocalService.deleteRuleGroup(ruleGroup);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MDRRuleGroup ruleGroup = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ruleGroup != null) {
            this.deleteStagedModel(ruleGroup);
        }
    }

    public MDRRuleGroup fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mdrRuleGroupLocalService.fetchMDRRuleGroupByUuidAndGroupId(uuid, groupId);
    }

    public List<MDRRuleGroup> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mdrRuleGroupLocalService.getMDRRuleGroupsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MDRRuleGroup ruleGroup) {
        return ruleGroup.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MDRRuleGroup ruleGroup) throws Exception {
        Element ruleGroupElement = portletDataContext.getExportDataElement((ClassedModel)ruleGroup);
        portletDataContext.addClassedModel(ruleGroupElement, ExportImportPathUtil.getModelPath((StagedModel)ruleGroup), (ClassedModel)ruleGroup);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long ruleGroupId) {
        MDRRuleGroup existingRuleGroup = (MDRRuleGroup)this.fetchMissingReference(uuid, groupId);
        if (existingRuleGroup == null) {
            return;
        }
        Map ruleGroupIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroup.class);
        ruleGroupIds.put(ruleGroupId, existingRuleGroup.getRuleGroupId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MDRRuleGroup ruleGroup) throws Exception {
        long userId = portletDataContext.getUserId(ruleGroup.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ruleGroup);
        serviceContext.setUserId(userId);
        MDRRuleGroup importedRuleGroup = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRuleGroup existingRuleGroup = this.fetchStagedModelByUuidAndGroupId(ruleGroup.getUuid(), portletDataContext.getScopeGroupId());
            if (existingRuleGroup == null) {
                serviceContext.setUuid(ruleGroup.getUuid());
                importedRuleGroup = this._mdrRuleGroupLocalService.addRuleGroup(portletDataContext.getScopeGroupId(), ruleGroup.getNameMap(), ruleGroup.getDescriptionMap(), serviceContext);
            } else {
                importedRuleGroup = this._mdrRuleGroupLocalService.updateRuleGroup(existingRuleGroup.getRuleGroupId(), ruleGroup.getNameMap(), ruleGroup.getDescriptionMap(), serviceContext);
            }
        } else {
            importedRuleGroup = this._mdrRuleGroupLocalService.addRuleGroup(portletDataContext.getScopeGroupId(), ruleGroup.getNameMap(), ruleGroup.getDescriptionMap(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)ruleGroup, (ClassedModel)importedRuleGroup);
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupLocalService(MDRRuleGroupLocalService mdrRuleGroupLocalService) {
        this._mdrRuleGroupLocalService = mdrRuleGroupLocalService;
    }
}

