/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.web.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleGroupLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MDRRuleGroupInstanceStagedModelDataHandler
extends BaseStagedModelDataHandler<MDRRuleGroupInstance> {
    public static final String[] CLASS_NAMES = new String[]{MDRRuleGroupInstance.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(MDRRuleGroupInstanceStagedModelDataHandler.class);
    private LayoutLocalService _layoutLocalService;
    private LayoutSetLocalService _layoutSetLocalService;
    private MDRRuleGroupInstanceLocalService _mdrRuleGroupInstanceLocalService;
    private MDRRuleGroupLocalService _mdrRuleGroupLocalService;

    public void deleteStagedModel(MDRRuleGroupInstance ruleGroupInstance) {
        this._mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MDRRuleGroupInstance ruleGroupInstance = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ruleGroupInstance != null) {
            this.deleteStagedModel(ruleGroupInstance);
        }
    }

    public MDRRuleGroupInstance fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mdrRuleGroupInstanceLocalService.fetchMDRRuleGroupInstanceByUuidAndGroupId(uuid, groupId);
    }

    public List<MDRRuleGroupInstance> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mdrRuleGroupInstanceLocalService.getMDRRuleGroupInstancesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MDRRuleGroupInstance ruleGroupInstance) throws Exception {
        MDRRuleGroup ruleGroup = this._mdrRuleGroupLocalService.getRuleGroup(ruleGroupInstance.getRuleGroupId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)ruleGroupInstance, (StagedModel)ruleGroup, (String)"parent");
        Element ruleGroupInstanceElement = portletDataContext.getExportDataElement((ClassedModel)ruleGroupInstance);
        String className = ruleGroupInstance.getClassName();
        if (className.equals(Layout.class.getName())) {
            Layout layout = this._layoutLocalService.getLayout(ruleGroupInstance.getClassPK());
            ruleGroupInstanceElement.addAttribute("layout-uuid", layout.getUuid());
        }
        portletDataContext.addClassedModel(ruleGroupInstanceElement, ExportImportPathUtil.getModelPath((StagedModel)ruleGroupInstance), (ClassedModel)ruleGroupInstance);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MDRRuleGroupInstance ruleGroupInstance) throws Exception {
        long userId = portletDataContext.getUserId(ruleGroupInstance.getUserUuid());
        Map ruleGroupIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroup.class);
        Long ruleGroupId = MapUtil.getLong((Map)ruleGroupIds, (long)ruleGroupInstance.getRuleGroupId(), (long)ruleGroupInstance.getRuleGroupId());
        long classPK = 0L;
        Element ruleGroupInstanceElement = portletDataContext.getImportDataStagedModelElement((StagedModel)ruleGroupInstance);
        String layoutUuid = ruleGroupInstanceElement.attributeValue("layout-uuid");
        try {
            if (Validator.isNotNull((String)layoutUuid)) {
                Layout layout = this._layoutLocalService.getLayoutByUuidAndGroupId(layoutUuid, portletDataContext.getScopeGroupId(), portletDataContext.isPrivateLayout());
                classPK = layout.getPrimaryKey();
            } else {
                LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getScopeGroupId(), portletDataContext.isPrivateLayout());
                classPK = layoutSet.getLayoutSetId();
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(5);
                sb.append("Layout ");
                sb.append(layoutUuid);
                sb.append(" is missing for rule group instance ");
                sb.append(ruleGroupInstance.getRuleGroupInstanceId());
                sb.append(", skipping this rule group instance.");
                _log.warn((Object)sb.toString());
            }
            return;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ruleGroupInstance);
        serviceContext.setUserId(userId);
        MDRRuleGroupInstance importedRuleGroupInstance = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRuleGroupInstance existingMDRRuleGroupInstance = this.fetchStagedModelByUuidAndGroupId(ruleGroupInstance.getUuid(), portletDataContext.getScopeGroupId());
            if (existingMDRRuleGroupInstance == null) {
                serviceContext.setUuid(ruleGroupInstance.getUuid());
                importedRuleGroupInstance = this._mdrRuleGroupInstanceLocalService.addRuleGroupInstance(portletDataContext.getScopeGroupId(), ruleGroupInstance.getClassName(), classPK, ruleGroupId.longValue(), ruleGroupInstance.getPriority(), serviceContext);
            } else {
                importedRuleGroupInstance = this._mdrRuleGroupInstanceLocalService.updateRuleGroupInstance(existingMDRRuleGroupInstance.getRuleGroupInstanceId(), ruleGroupInstance.getPriority());
            }
        } else {
            importedRuleGroupInstance = this._mdrRuleGroupInstanceLocalService.addRuleGroupInstance(portletDataContext.getScopeGroupId(), ruleGroupInstance.getClassName(), classPK, ruleGroupId.longValue(), ruleGroupInstance.getPriority(), serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)ruleGroupInstance, (ClassedModel)importedRuleGroupInstance);
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupInstanceLocalService(MDRRuleGroupInstanceLocalService mdrRuleGroupInstanceLocalService) {
        this._mdrRuleGroupInstanceLocalService = mdrRuleGroupInstanceLocalService;
    }

    @Reference(unbind="-")
    protected void setMDRRuleGroupLocalService(MDRRuleGroupLocalService mdrRuleGroupLocalService) {
        this._mdrRuleGroupLocalService = mdrRuleGroupLocalService;
    }
}

