/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.action;

import com.liferay.mobile.device.rules.action.ActionHandler;
import com.liferay.mobile.device.rules.action.ActionHandlerManager;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class ActionHandlerManagerUtil {
    private static final ActionHandlerManagerUtil _instance = new ActionHandlerManagerUtil();
    private final ServiceTracker<ActionHandlerManager, ActionHandlerManager> _serviceTracker;

    public static void applyActions(List<MDRAction> mdrActions, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        ActionHandlerManagerUtil.getActionHandlerManager().applyActions(mdrActions, request, response);
    }

    public static ActionHandler getActionHandler(String actionType) {
        return ActionHandlerManagerUtil.getActionHandlerManager().getActionHandler(actionType);
    }

    public static ActionHandlerManager getActionHandlerManager() {
        PortalRuntimePermission.checkGetBeanProperty(ActionHandlerManagerUtil.class);
        return _instance._getActionHandlerManager();
    }

    public static Collection<ActionHandler> getActionHandlers() {
        return ActionHandlerManagerUtil.getActionHandlerManager().getActionHandlers();
    }

    public static Collection<String> getActionHandlerTypes() {
        return ActionHandlerManagerUtil.getActionHandlerManager().getActionHandlerTypes();
    }

    public static void registerActionHandler(ActionHandler actionHandler) {
        ActionHandlerManagerUtil.getActionHandlerManager().registerActionHandler(actionHandler);
    }

    public static ActionHandler unregisterActionHandler(String actionType) {
        return ActionHandlerManagerUtil.getActionHandlerManager().unregisterActionHandler(actionType);
    }

    private ActionHandlerManagerUtil() {
        Bundle bundle = FrameworkUtil.getBundle(ActionHandlerManagerUtil.class);
        this._serviceTracker = ServiceTrackerFactory.open((Bundle)bundle, ActionHandlerManager.class);
    }

    private ActionHandlerManager _getActionHandlerManager() {
        return (ActionHandlerManager)this._serviceTracker.getService();
    }
}

