/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class MBMessageServiceUtil {
    private static ServiceTracker<MBMessageService, MBMessageService> _serviceTracker;

    public static MBMessage addDiscussionMessage(long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        return MBMessageServiceUtil.getService().addDiscussionMessage(groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
    }

    public static MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return MBMessageServiceUtil.getService().addMessage(groupId, categoryId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public static MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, String fileName, File file, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, FileNotFoundException {
        return MBMessageServiceUtil.getService().addMessage(groupId, categoryId, subject, body, format, fileName, file, anonymous, priority, allowPingbacks, serviceContext);
    }

    public static MBMessage addMessage(long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        return MBMessageServiceUtil.getService().addMessage(categoryId, subject, body, serviceContext);
    }

    public static MBMessage addMessage(long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return MBMessageServiceUtil.getService().addMessage(parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public static void addMessageAttachment(long messageId, String fileName, File file, String mimeType) throws PortalException {
        MBMessageServiceUtil.getService().addMessageAttachment(messageId, fileName, file, mimeType);
    }

    public static FileEntry addTempAttachment(long groupId, long categoryId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        return MBMessageServiceUtil.getService().addTempAttachment(groupId, categoryId, folderName, fileName, inputStream, mimeType);
    }

    public static void deleteDiscussionMessage(long messageId) throws PortalException {
        MBMessageServiceUtil.getService().deleteDiscussionMessage(messageId);
    }

    public static void deleteMessage(long messageId) throws PortalException {
        MBMessageServiceUtil.getService().deleteMessage(messageId);
    }

    public static void deleteMessageAttachment(long messageId, String fileName) throws PortalException {
        MBMessageServiceUtil.getService().deleteMessageAttachment(messageId, fileName);
    }

    public static void deleteMessageAttachments(long messageId) throws PortalException {
        MBMessageServiceUtil.getService().deleteMessageAttachments(messageId);
    }

    public static void deleteTempAttachment(long groupId, long categoryId, String folderName, String fileName) throws PortalException {
        MBMessageServiceUtil.getService().deleteTempAttachment(groupId, categoryId, folderName, fileName);
    }

    public static void emptyMessageAttachments(long messageId) throws PortalException {
        MBMessageServiceUtil.getService().emptyMessageAttachments(messageId);
    }

    public static List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws PortalException {
        return MBMessageServiceUtil.getService().getCategoryMessages(groupId, categoryId, status, start, end);
    }

    public static int getCategoryMessagesCount(long groupId, long categoryId, int status) {
        return MBMessageServiceUtil.getService().getCategoryMessagesCount(groupId, categoryId, status);
    }

    public static String getCategoryMessagesRSS(long groupId, long categoryId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return MBMessageServiceUtil.getService().getCategoryMessagesRSS(groupId, categoryId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public static String getCompanyMessagesRSS(long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return MBMessageServiceUtil.getService().getCompanyMessagesRSS(companyId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public static int getGroupMessagesCount(long groupId, int status) {
        return MBMessageServiceUtil.getService().getGroupMessagesCount(groupId, status);
    }

    public static String getGroupMessagesRSS(long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return MBMessageServiceUtil.getService().getGroupMessagesRSS(groupId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public static String getGroupMessagesRSS(long groupId, long userId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return MBMessageServiceUtil.getService().getGroupMessagesRSS(groupId, userId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public static MBMessage getMessage(long messageId) throws PortalException {
        return MBMessageServiceUtil.getService().getMessage(messageId);
    }

    public static MBMessageDisplay getMessageDisplay(long messageId, int status) throws PortalException {
        return MBMessageServiceUtil.getService().getMessageDisplay(messageId, status);
    }

    public static String getOSGiServiceIdentifier() {
        return MBMessageServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static String[] getTempAttachmentNames(long groupId, String folderName) throws PortalException {
        return MBMessageServiceUtil.getService().getTempAttachmentNames(groupId, folderName);
    }

    public static int getThreadAnswersCount(long groupId, long categoryId, long threadId) {
        return MBMessageServiceUtil.getService().getThreadAnswersCount(groupId, categoryId, threadId);
    }

    public static List<MBMessage> getThreadMessages(long groupId, long categoryId, long threadId, int status, int start, int end) {
        return MBMessageServiceUtil.getService().getThreadMessages(groupId, categoryId, threadId, status, start, end);
    }

    public static int getThreadMessagesCount(long groupId, long categoryId, long threadId, int status) {
        return MBMessageServiceUtil.getService().getThreadMessagesCount(groupId, categoryId, threadId, status);
    }

    public static String getThreadMessagesRSS(long threadId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return MBMessageServiceUtil.getService().getThreadMessagesRSS(threadId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public static void moveMessageAttachmentToTrash(long messageId, String fileName) throws PortalException {
        MBMessageServiceUtil.getService().moveMessageAttachmentToTrash(messageId, fileName);
    }

    public static void restoreMessageAttachmentFromTrash(long messageId, String fileName) throws PortalException {
        MBMessageServiceUtil.getService().restoreMessageAttachmentFromTrash(messageId, fileName);
    }

    public static void subscribeMessage(long messageId) throws PortalException {
        MBMessageServiceUtil.getService().subscribeMessage(messageId);
    }

    public static void unsubscribeMessage(long messageId) throws PortalException {
        MBMessageServiceUtil.getService().unsubscribeMessage(messageId);
    }

    public static void updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException {
        MBMessageServiceUtil.getService().updateAnswer(messageId, answer, cascade);
    }

    public static MBMessage updateDiscussionMessage(String className, long classPK, long messageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        return MBMessageServiceUtil.getService().updateDiscussionMessage(className, classPK, messageId, subject, body, serviceContext);
    }

    public static MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return MBMessageServiceUtil.getService().updateMessage(messageId, subject, body, inputStreamOVPs, priority, allowPingbacks, serviceContext);
    }

    @Deprecated
    public static MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return MBMessageServiceUtil.getService().updateMessage(messageId, subject, body, inputStreamOVPs, existingFiles, priority, allowPingbacks, serviceContext);
    }

    public static MBMessageService getService() {
        return (MBMessageService)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(MBMessageService.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), MBMessageService.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

