/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.settings;

import com.liferay.message.boards.util.MBUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.rss.util.RSSUtil;
import java.util.Map;

@Settings.Config
public class MBGroupServiceSettings {
    public static final String[] ALL_KEYS = new String[0];
    private final TypedSettings _typedSettings;

    public static MBGroupServiceSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.message.boards"));
        return new MBGroupServiceSettings(settings);
    }

    public static MBGroupServiceSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.message.boards"));
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new MBGroupServiceSettings((Settings)parameterMapSettings);
    }

    public MBGroupServiceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public LocalizedValuesMap getEmailMessageAddedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageAddedBody");
    }

    public String getEmailMessageAddedBodyXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailMessageAddedBody(), (String)"emailMessageAddedBody");
    }

    public LocalizedValuesMap getEmailMessageAddedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageAddedSubject");
    }

    public String getEmailMessageAddedSubjectXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailMessageAddedSubject(), (String)"emailMessageAddedSubject");
    }

    public LocalizedValuesMap getEmailMessageUpdatedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageUpdatedBody");
    }

    public String getEmailMessageUpdatedBodyXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailMessageUpdatedBody(), (String)"emailMessageUpdatedBody");
    }

    public LocalizedValuesMap getEmailMessageUpdatedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailMessageUpdatedSubject");
    }

    public String getEmailMessageUpdatedSubjectXml() {
        return LocalizationUtil.getXml((LocalizedValuesMap)this.getEmailMessageUpdatedSubject(), (String)"emailMessageUpdatedSubject");
    }

    public String getMessageFormat() {
        String messageFormat = this._typedSettings.getValue("messageFormat");
        if (MBUtil.isValidMessageFormat(messageFormat)) {
            return messageFormat;
        }
        return "html";
    }

    public String[] getPriorities(String currentLanguageId) {
        return LocalizationUtil.getSettingsValues((Settings)this._typedSettings.getWrappedSettings(), (String)"priorities", (String)currentLanguageId);
    }

    public String[] getRanks(String languageId) {
        return LocalizationUtil.getSettingsValues((Settings)this._typedSettings.getWrappedSettings(), (String)"ranks", (String)languageId);
    }

    public String getRecentPostsDateOffset() {
        return this._typedSettings.getValue("recentPostsDateOffset");
    }

    @Settings.Property(name="rssDelta")
    public int getRSSDelta() {
        return this._typedSettings.getIntegerValue("rssDelta");
    }

    @Settings.Property(name="rssDisplayStyle")
    public String getRSSDisplayStyle() {
        return this._typedSettings.getValue("rssDisplayStyle", "full-content");
    }

    @Settings.Property(name="rssFeedType")
    public String getRSSFeedType() {
        return this._typedSettings.getValue("rssFeedType", RSSUtil.getFeedType((String)"atom", (double)1.0));
    }

    public boolean isAllowAnonymousPosting() {
        return this._typedSettings.getBooleanValue("allowAnonymousPosting");
    }

    public boolean isEmailHtmlFormat() {
        return this._typedSettings.getBooleanValue("emailHtmlFormat");
    }

    public boolean isEmailMessageAddedEnabled() {
        return this._typedSettings.getBooleanValue("emailMessageAddedEnabled");
    }

    public boolean isEmailMessageUpdatedEnabled() {
        return this._typedSettings.getBooleanValue("emailMessageUpdatedEnabled");
    }

    public boolean isEnableFlags() {
        return this._typedSettings.getBooleanValue("enableFlags");
    }

    public boolean isEnableRatings() {
        return this._typedSettings.getBooleanValue("enableRatings");
    }

    @Settings.Property(name="enableRss")
    public boolean isEnableRSS() {
        if (!PortalUtil.isRSSFeedsEnabled()) {
            return false;
        }
        return this._typedSettings.getBooleanValue("enableRss");
    }

    public boolean isSubscribeByDefault() {
        return this._typedSettings.getBooleanValue("subscribeByDefault");
    }

    public boolean isThreadAsQuestionByDefault() {
        return this._typedSettings.getBooleanValue("threadAsQuestionByDefault");
    }
}

