Liferay.Loader.define("map-google-maps@4.0.12/js/GoogleMapsGeocoder.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.GoogleMapsGeocoder = exports["default"] = void 0;

    var _metalState = _interopRequireDefault(require("frontend-js-metal-web$metal-state"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    /**
     * GoogleMapsGeocoder
     * @review
     */
    var GoogleMapsGeocoder = /*#__PURE__*/function (_State) {
      _inherits(GoogleMapsGeocoder, _State);

      /**
       * Creates a new geocoder using Google Map's API
       * @param  {Array} args List of arguments to be passed to State
       * @review
       */
      function GoogleMapsGeocoder() {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, GoogleMapsGeocoder);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(GoogleMapsGeocoder)).call.apply(_getPrototypeOf2, [this].concat(args)));
        _this._geocoder = new google.maps.Geocoder();
        return _this;
      }
      /**
       * Handles the server response of a successfull address/location resolution
       * @param {function} callback Callback that will be executed on success
       * @param {Object} location Raw location information
       * @param {Object} response Server response
       * @param {Object} status Server response status
       * @protected
       * @review
       */

      _createClass(GoogleMapsGeocoder, [{
        key: "_handleGeocoderResponse",
        value: function _handleGeocoderResponse(callback, location, response, status) {
          var result = {
            data: {},
            err: status === google.maps.GeocoderStatus.OK ? null : status
          };

          if (!result.err) {
            var geocoderResult = response[0];
            var geolocation = geocoderResult.geometry.location;
            result.data = {
              address: geocoderResult.formatted_address,
              location: {
                lat: geolocation.lat(),
                lng: geolocation.lng()
              }
            };
          } else {
            result.data = {
              address: '',
              location: location
            };
          }

          callback(result);
        }
        /**
         * Transforms a given address into valid latitude and longitude
         * @param {string} query Address to be transformed into latitude and longitude
         * @param {function} callback Callback that will be executed on success
         * @review
         */

      }, {
        key: "forward",
        value: function forward(query, callback) {

          this._geocoder.geocode({
            address: query
          }, this._handleGeocoderResponse.bind(this, callback));
        }
        /**
         * Transforms a given location object (lat, lng) into a valid address
         * @param {string} location Location information to be sent to the server
         * @param {function} callback Callback that will be executed on success
         * @review
         */

      }, {
        key: "reverse",
        value: function reverse(location, callback) {

          this._geocoder.geocode({
            location: location
          }, this._handleGeocoderResponse.bind(this, callback, location));
        }
      }]);

      return GoogleMapsGeocoder;
    }(_metalState["default"]);

    exports.GoogleMapsGeocoder = GoogleMapsGeocoder;
    var _default = GoogleMapsGeocoder;
    exports["default"] = _default;
    //# sourceMappingURL=GoogleMapsGeocoder.es.js.map
  }
});
//# sourceMappingURL=GoogleMapsGeocoder.es.js.map