"use strict";

Liferay.Loader.define("map-google-maps@3.0.5/js/MapGoogleMaps.es", ['module', 'exports', 'require', 'map-common/js/MapBase.es', 'frontend-js-metal-web$metal-dom', './GoogleMapsDialog.es', './GoogleMapsGeoJSON.es', './GoogleMapsGeocoder.es', './GoogleMapsMarker.es', './GoogleMapsSearch.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.MapGoogleMaps = exports.default = void 0;

  var _MapBase2 = _interopRequireDefault(require("map-common/js/MapBase.es"));

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _GoogleMapsDialog = _interopRequireDefault(require("./GoogleMapsDialog.es"));

  var _GoogleMapsGeoJSON = _interopRequireDefault(require("./GoogleMapsGeoJSON.es"));

  var _GoogleMapsGeocoder = _interopRequireDefault(require("./GoogleMapsGeocoder.es"));

  var _GoogleMapsMarker = _interopRequireDefault(require("./GoogleMapsMarker.es"));

  var _GoogleMapsSearch = _interopRequireDefault(require("./GoogleMapsSearch.es"));

  var _MapGoogleMaps$CONTRO;

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * MapGoogleMaps
   * @review
   */
  var MapGoogleMaps =
  /*#__PURE__*/
  function (_MapBase) {
    _inherits(MapGoogleMaps, _MapBase);

    /**
     * Creates a new map using Google Map's API
     * @param  {Array} args List of arguments to be passed to State
     * @review
     */
    function MapGoogleMaps() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, MapGoogleMaps);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(MapGoogleMaps)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this._bounds = null;
      return _this;
    }
    /**
     * @inheritDoc
     * @review
     */

    _createClass(MapGoogleMaps, [{
      key: "_createMap",
      value: function _createMap(location, controlsConfig) {
        var mapConfig = {
          center: location,
          mapTypeId: google.maps.MapTypeId.ROADMAP,
          zoom: this.zoom
        };
        var map = new google.maps.Map((0, _metalDom.toElement)(this.boundingBox), Object.assign(mapConfig, controlsConfig));

        if (this.data && this.data.features) {
          var bounds = new google.maps.LatLngBounds();
          this.data.features.forEach(function (feature) {
            return bounds.extend(new google.maps.LatLng(feature.geometry.coordinates[1], feature.geometry.coordinates[0]));
          });
          map.fitBounds(bounds);
        }

        return map;
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "addControl",
      value: function addControl(control, position) {
        if (this._map.controls[position]) {
          this._map.controls[position].push((0, _metalDom.toElement)(control));
        }
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "getBounds",
      value: function getBounds() {
        var bounds = this._map.getBounds() || this._bounds;

        if (!bounds) {
          bounds = new google.maps.LatLngBounds();
          this._bounds = bounds;
        }

        return bounds;
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "setCenter",
      value: function setCenter(location) {
        if (this._map) {
          this._map.setCenter(location);
        }
      }
    }]);

    return MapGoogleMaps;
  }(_MapBase2.default);

  exports.MapGoogleMaps = MapGoogleMaps;
  _MapBase2.default.DialogImpl = _GoogleMapsDialog.default;
  _MapBase2.default.GeocoderImpl = _GoogleMapsGeocoder.default;
  _MapBase2.default.GeoJSONImpl = _GoogleMapsGeoJSON.default;
  _MapBase2.default.MarkerImpl = _GoogleMapsMarker.default;
  _MapBase2.default.SearchImpl = _GoogleMapsSearch.default;
  MapGoogleMaps.CONTROLS_MAP = (_MapGoogleMaps$CONTRO = {}, _defineProperty(_MapGoogleMaps$CONTRO, _MapBase2.default.CONTROLS.OVERVIEW, 'overviewMapControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase2.default.CONTROLS.PAN, 'panControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase2.default.CONTROLS.ROTATE, 'rotateControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase2.default.CONTROLS.SCALE, 'scaleControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase2.default.CONTROLS.STREETVIEW, 'streetViewControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase2.default.CONTROLS.TYPE, 'mapTypeControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase2.default.CONTROLS.ZOOM, 'zoomControl'), _MapGoogleMaps$CONTRO);
  window.Liferay = window.Liferay || {};
  window.Liferay.GoogleMap = MapGoogleMaps;
  var _default = MapGoogleMaps;
  exports.default = _default;
  //# sourceMappingURL=MapGoogleMaps.es.js.map
});
//# sourceMappingURL=MapGoogleMaps.es.js.map