Liferay.Loader.define("map-google-maps@3.0.31/js/GoogleMapsSearch.es", ['module', 'exports', 'require', 'map-common/js/validators.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.GoogleMapsSearch = exports["default"] = void 0;

  var _validators = require("map-common/js/validators.es");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalState = _interopRequireWildcard(require("frontend-js-metal-web$metal-state"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * GoogleMapsSearch
   * @review
   */
  var GoogleMapsSearch = /*#__PURE__*/function (_State) {
    _inherits(GoogleMapsSearch, _State);

    /**
     * Creates a new search handler using Google Map's API
     * @param  {Array} args List of arguments to be passed to State
     * @review
     */
    function GoogleMapsSearch() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, GoogleMapsSearch);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(GoogleMapsSearch)).call.apply(_getPrototypeOf2, [this].concat(args)));
      var inputNode = (0, _metalDom.toElement)(_this.inputNode);
      _this._handlePlaceChanged = _this._handlePlaceChanged.bind(_assertThisInitialized(_this));
      _this._autocomplete = new google.maps.places.Autocomplete(inputNode);

      _this._bindUI();

      return _this;
    }
    /**
     * Removes the listeners that have been added to the search input.
     * @review
     */

    _createClass(GoogleMapsSearch, [{
      key: "destructor",
      value: function destructor() {
        this._eventHandlers.forEach(function (item) {
          google.maps.event.removeListener(item);
        });
      }
      /**
       * Adds listeners for the created map object.
       * It listens for a custom 'place_changed' event and executes
       * GoogleMapsSearch._handlePlaceChanged.
       * @protected
       * @review
       */

    }, {
      key: "_bindUI",
      value: function _bindUI() {
        this._eventHandlers = [google.maps.event.addListener(this._autocomplete, 'place_changed', this._handlePlaceChanged), google.maps.event.addDomListener(this.inputNode, 'keydown', function (event) {
          if (event.keyCode === 13) {
            event.preventDefault();
          }
        })];
      }
      /**
       * Gets the new place that has been processed by Google Maps and emits a
       * 'search' event with the location information and the address.
       * @protected
       * @review
       */

    }, {
      key: "_handlePlaceChanged",
      value: function _handlePlaceChanged() {
        var place = this._autocomplete.getPlace();

        if (place && _typeof(place) === 'object' && place.geometry) {
          var geolocation = place.geometry.location;
          this.emit('search', {
            position: {
              address: place.formatted_address,
              location: {
                lat: geolocation.lat(),
                lng: geolocation.lng()
              }
            }
          });
        }
      }
    }]);

    return GoogleMapsSearch;
  }(_metalState["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.GoogleMapsSearch = GoogleMapsSearch;
  GoogleMapsSearch.STATE = {
    /**
     * Input element that will be used for searching addresses.
     * @review
     * @type {HTMLInputElement}
     */
    inputNode: _metalState.Config.validator(_validators.isInputNode).value(null)
  };
  var _default = GoogleMapsSearch;
  exports["default"] = _default;
  //# sourceMappingURL=GoogleMapsSearch.es.js.map
});
//# sourceMappingURL=GoogleMapsSearch.es.js.map