'use strict';

Liferay.Loader.define("map-google-maps@2.0.6/js/GoogleMapsMarker.es", ['module', 'exports', 'require', 'map-common/js/MarkerBase.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.GoogleMapsMarker = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _MarkerBase2 = require('map-common/js/MarkerBase.es');

	var _MarkerBase3 = _interopRequireDefault(_MarkerBase2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * GoogleMapsMarker
  * @review
  */
	var GoogleMapsMarker = function (_MarkerBase) {
		_inherits(GoogleMapsMarker, _MarkerBase);

		function GoogleMapsMarker() {
			_classCallCheck(this, GoogleMapsMarker);

			return _possibleConstructorReturn(this, (GoogleMapsMarker.__proto__ || Object.getPrototypeOf(GoogleMapsMarker)).apply(this, arguments));
		}

		_createClass(GoogleMapsMarker, [{
			key: 'setPosition',

			/**
    * If a marked has been created, sets the marker location to the given one
    * @param {Object} location Location to set the native marker in
    * @review
    */
			value: function setPosition(location) {
				if (this._nativeMarker) {
					this._nativeMarker.setPosition(location);
				}
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: '_getNativeMarker',
			value: function _getNativeMarker(location, map) {
				if (!this._nativeMarker) {
					this._nativeMarker = new google.maps.Marker({
						draggable: true,
						map: map,
						position: location
					});

					google.maps.event.addListener(this._nativeMarker, 'click', this._getNativeEventFunction('click'));

					google.maps.event.addListener(this._nativeMarker, 'dblclick', this._getNativeEventFunction('dblclick'));

					google.maps.event.addListener(this._nativeMarker, 'drag', this._getNativeEventFunction('drag'));

					google.maps.event.addListener(this._nativeMarker, 'dragend', this._getNativeEventFunction('dragend'));

					google.maps.event.addListener(this._nativeMarker, 'dragstart', this._getNativeEventFunction('dragstart'));

					google.maps.event.addListener(this._nativeMarker, 'mousedown', this._getNativeEventFunction('mousedown'));

					google.maps.event.addListener(this._nativeMarker, 'mouseout', this._getNativeEventFunction('mouseout'));

					google.maps.event.addListener(this._nativeMarker, 'mouseover', this._getNativeEventFunction('mouseover'));
				}

				return this._nativeMarker;
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: '_getNormalizedEventData',
			value: function _getNormalizedEventData(nativeEvent) {
				return {
					location: {
						lat: nativeEvent.latLng.lat(),
						lng: nativeEvent.latLng.lng()
					}
				};
			}
		}]);

		return GoogleMapsMarker;
	}(_MarkerBase3.default);

	exports.default = GoogleMapsMarker;
	exports.GoogleMapsMarker = GoogleMapsMarker;
	//# sourceMappingURL=GoogleMapsMarker.es.js.map
});
//# sourceMappingURL=GoogleMapsMarker.es.js.map