'use strict';

Liferay.Loader.define("map-google-maps@2.0.6/js/GoogleMapsGeoJSON.es", ['module', 'exports', 'require', 'map-common/js/GeoJSONBase.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.GoogleMapsGeoJSON = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _GeoJSONBase2 = require('map-common/js/GeoJSONBase.es');

	var _GeoJSONBase3 = _interopRequireDefault(_GeoJSONBase2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * GoogleMapsGeoJSON
  * @review
  */
	var GoogleMapsGeoJSON = function (_GeoJSONBase) {
		_inherits(GoogleMapsGeoJSON, _GeoJSONBase);

		/**
   * Creates a new geojson parser using Google Map's API
   * @param  {Array} args List of arguments to be passed to State
   * @review
   */
		function GoogleMapsGeoJSON() {
			var _ref;

			_classCallCheck(this, GoogleMapsGeoJSON);

			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = GoogleMapsGeoJSON.__proto__ || Object.getPrototypeOf(GoogleMapsGeoJSON)).call.apply(_ref, [this].concat(args)));

			_this.eventHandlers = [];

			_this._getFeatureStyle = _this._getFeatureStyle.bind(_this);
			_this._handleFeatureClicked = _this._handleFeatureClicked.bind(_this);

			_this.map.data.setStyle(_this._getFeatureStyle);

			_this._bindUI();
			return _this;
		}

		/**
   * Removes the listeners that have been added to the map object.
   * @review
   */

		_createClass(GoogleMapsGeoJSON, [{
			key: 'destructor',
			value: function destructor() {
				this._eventHandlers.forEach(function (item) {
					google.maps.event.removeListener(item);
				});
			}

			/**
    * Adds listeners for the created map object.
    * It listens for click events and executes
    * GoogleMapsGeoJSON._handleFeatureClicked.
    * @protected
    * @review
    */

		}, {
			key: '_bindUI',
			value: function _bindUI() {
				this._eventHandlers = [google.maps.event.addListener(this.map.data, 'click', this._handleFeatureClicked)];
			}

			/**
    * Gets the internal style of the given feature. Both the feature and the
    * style are native Google Maps objects.
    * @param {Object} feature Google Maps native feature to be parsed.
    * @protected
    * @return {Object} Obtained style
    * @review
    */

		}, {
			key: '_getFeatureStyle',
			value: function _getFeatureStyle(feature) {
				return {
					icon: feature.getProperty('icon')
				};
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: '_getNativeFeatures',
			value: function _getNativeFeatures(geoJSONData) {
				return this.map.data.addGeoJson(geoJSONData);
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: '_wrapNativeFeature',
			value: function _wrapNativeFeature(nativeFeature) {
				var _this2 = this;

				var feature = nativeFeature.getGeometry ? nativeFeature : nativeFeature.feature;

				feature.getMarker = function () {
					if (!feature._marker) {
						var marker = new google.maps.Marker({
							icon: feature.getProperty('icon'),
							map: _this2.map,
							opacity: 0,
							position: feature.getGeometry().get('location'),
							zIndex: -1
						});

						feature._marker = marker;
					}

					return feature.marker;
				};

				return feature;
			}
		}]);

		return GoogleMapsGeoJSON;
	}(_GeoJSONBase3.default);

	exports.default = GoogleMapsGeoJSON;
	exports.GoogleMapsGeoJSON = GoogleMapsGeoJSON;
	//# sourceMappingURL=GoogleMapsGeoJSON.es.js.map
});
//# sourceMappingURL=GoogleMapsGeoJSON.es.js.map