'use strict';

Liferay.Loader.define("map-google-maps@2.0.11/js/MapGoogleMaps.es", ['module', 'exports', 'require', 'map-common/js/MapBase.es', 'frontend-js-metal-web$metal-dom', './GoogleMapsDialog.es', './GoogleMapsGeoJSON.es', './GoogleMapsGeocoder.es', './GoogleMapsMarker.es', './GoogleMapsSearch.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.MapGoogleMaps = undefined;

	var _MapGoogleMaps$CONTRO;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _MapBase2 = require('map-common/js/MapBase.es');

	var _MapBase3 = _interopRequireDefault(_MapBase2);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _GoogleMapsDialog = require('./GoogleMapsDialog.es');

	var _GoogleMapsDialog2 = _interopRequireDefault(_GoogleMapsDialog);

	var _GoogleMapsGeoJSON = require('./GoogleMapsGeoJSON.es');

	var _GoogleMapsGeoJSON2 = _interopRequireDefault(_GoogleMapsGeoJSON);

	var _GoogleMapsGeocoder = require('./GoogleMapsGeocoder.es');

	var _GoogleMapsGeocoder2 = _interopRequireDefault(_GoogleMapsGeocoder);

	var _GoogleMapsMarker = require('./GoogleMapsMarker.es');

	var _GoogleMapsMarker2 = _interopRequireDefault(_GoogleMapsMarker);

	var _GoogleMapsSearch = require('./GoogleMapsSearch.es');

	var _GoogleMapsSearch2 = _interopRequireDefault(_GoogleMapsSearch);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _defineProperty(obj, key, value) {
		if (key in obj) {
			Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
		} else {
			obj[key] = value;
		}return obj;
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * MapGoogleMaps
  * @review
  */
	var MapGoogleMaps = function (_MapBase) {
		_inherits(MapGoogleMaps, _MapBase);

		/**
   * Creates a new map using Google Map's API
   * @param  {Array} args List of arguments to be passed to State
   * @review
   */
		function MapGoogleMaps() {
			var _ref;

			_classCallCheck(this, MapGoogleMaps);

			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = MapGoogleMaps.__proto__ || Object.getPrototypeOf(MapGoogleMaps)).call.apply(_ref, [this].concat(args)));

			_this._bounds = null;
			return _this;
		}

		/**
   * @inheritDoc
   * @review
   */

		_createClass(MapGoogleMaps, [{
			key: '_createMap',
			value: function _createMap(location, controlsConfig) {
				var mapConfig = {
					center: location,
					mapTypeId: google.maps.MapTypeId.ROADMAP,
					zoom: this.zoom
				};

				var map = new google.maps.Map((0, _metalDom.toElement)(this.boundingBox), Object.assign(mapConfig, controlsConfig));

				if (this.data && this.data.features) {
					var bounds = new google.maps.LatLngBounds();

					this.data.features.forEach(function (feature) {
						return bounds.extend(new google.maps.LatLng(feature.geometry.coordinates[1], feature.geometry.coordinates[0]));
					});

					map.fitBounds(bounds);
				}

				return map;
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: 'addControl',
			value: function addControl(control, position) {
				if (this._map.controls[position]) {
					this._map.controls[position].push((0, _metalDom.toElement)(control));
				}
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: 'getBounds',
			value: function getBounds() {
				var bounds = this._map.getBounds() || this._bounds;

				if (!bounds) {
					bounds = new google.maps.LatLngBounds();

					this._bounds = bounds;
				}

				return bounds;
			}

			/**
    * @inheritDoc
    * @review
    */

		}, {
			key: 'setCenter',
			value: function setCenter(location) {
				if (this._map) {
					this._map.setCenter(location);
				}
			}
		}]);

		return MapGoogleMaps;
	}(_MapBase3.default);

	_MapBase3.default.DialogImpl = _GoogleMapsDialog2.default;

	_MapBase3.default.GeocoderImpl = _GoogleMapsGeocoder2.default;

	_MapBase3.default.GeoJSONImpl = _GoogleMapsGeoJSON2.default;

	_MapBase3.default.MarkerImpl = _GoogleMapsMarker2.default;

	_MapBase3.default.SearchImpl = _GoogleMapsSearch2.default;

	MapGoogleMaps.CONTROLS_MAP = (_MapGoogleMaps$CONTRO = {}, _defineProperty(_MapGoogleMaps$CONTRO, _MapBase3.default.CONTROLS.OVERVIEW, 'overviewMapControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase3.default.CONTROLS.PAN, 'panControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase3.default.CONTROLS.ROTATE, 'rotateControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase3.default.CONTROLS.SCALE, 'scaleControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase3.default.CONTROLS.STREETVIEW, 'streetViewControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase3.default.CONTROLS.TYPE, 'mapTypeControl'), _defineProperty(_MapGoogleMaps$CONTRO, _MapBase3.default.CONTROLS.ZOOM, 'zoomControl'), _MapGoogleMaps$CONTRO);

	window.Liferay = window.Liferay || {};
	window.Liferay.GoogleMap = MapGoogleMaps;

	exports.default = MapGoogleMaps;
	exports.MapGoogleMaps = MapGoogleMaps;
	//# sourceMappingURL=MapGoogleMaps.es.js.map
});
//# sourceMappingURL=MapGoogleMaps.es.js.map