'use strict';

Liferay.Loader.define("map-google-maps@2.0.11/js/GoogleMapsGeocoder.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.GoogleMapsGeocoder = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * GoogleMapsGeocoder
  * @review
  */
	var GoogleMapsGeocoder = function (_State) {
		_inherits(GoogleMapsGeocoder, _State);

		/**
   * Creates a new geocoder using Google Map's API
   * @param  {Array} args List of arguments to be passed to State
   * @review
   */
		function GoogleMapsGeocoder() {
			var _ref;

			_classCallCheck(this, GoogleMapsGeocoder);

			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = GoogleMapsGeocoder.__proto__ || Object.getPrototypeOf(GoogleMapsGeocoder)).call.apply(_ref, [this].concat(args)));

			_this._geocoder = new google.maps.Geocoder();
			return _this;
		}

		/**
   * Handles the server response of a successfull address/location resolution
   * @param {function} callback Callback that will be executed on success
   	 * @param {Object} location Raw location information
   * @param {Object} response Server response
   * @param {Object} status Server response status
   * @protected
   * @review
   */

		_createClass(GoogleMapsGeocoder, [{
			key: '_handleGeocoderResponse',
			value: function _handleGeocoderResponse(callback, location, response, status) {
				var result = {
					data: {},
					err: status === google.maps.GeocoderStatus.OK ? null : status
				};

				if (!result.err) {
					var geocoderResult = response[0];
					var geolocation = geocoderResult.geometry.location;

					result.data = {
						address: geocoderResult.formatted_address,
						location: {
							lat: geolocation.lat(),
							lng: geolocation.lng()
						}
					};
				} else {
					result.data = {
						address: '',
						location: location
					};
				}

				callback(result);
			}

			/**
    * Transforms a given address into valid latitude and longitude
    * @param {string} query Address to be transformed into latitude and longitude
    * @param {function} callback Callback that will be executed on success
    * @review
    */

		}, {
			key: 'forward',
			value: function forward(query, callback) {
				var payload = {
					address: query
				};

				this._geocoder.geocode(payload, this._handleGeocoderResponse.bind(this, callback));
			}

			/**
    * Transforms a given location object (lat, lng) into a valid address
    * @param {string} location Location information to be sent to the server
    * @param {function} callback Callback that will be executed on success
    * @review
    */

		}, {
			key: 'reverse',
			value: function reverse(location, callback) {
				var payload = {
					location: location
				};

				this._geocoder.geocode(payload, this._handleGeocoderResponse.bind(this, callback, location));
			}
		}]);

		return GoogleMapsGeocoder;
	}(_metalState2.default);

	exports.default = GoogleMapsGeocoder;
	exports.GoogleMapsGeocoder = GoogleMapsGeocoder;
	//# sourceMappingURL=GoogleMapsGeocoder.es.js.map
});
//# sourceMappingURL=GoogleMapsGeocoder.es.js.map