'use strict';

Liferay.Loader.define("map-google-maps@2.0.11/js/GoogleMapsDialog.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.GoogleMapsDialog = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * GoogleMapsDialog
  * @review
  */
	var GoogleMapsDialog = function (_State) {
		_inherits(GoogleMapsDialog, _State);

		/**
   * Creates a new map dialog using Google Map's API
   * @param  {Array} args List of arguments to be passed to State
   * @review
   */
		function GoogleMapsDialog() {
			var _ref;

			_classCallCheck(this, GoogleMapsDialog);

			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = GoogleMapsDialog.__proto__ || Object.getPrototypeOf(GoogleMapsDialog)).call.apply(_ref, [this].concat(args)));

			_this._dialog = new google.maps.InfoWindow();
			return _this;
		}

		/**
   * Opens the dialog with the given map attribute and passes
   * the given configuration to the dialog object.
   * @param {Object} cfg
   * @review
   */

		_createClass(GoogleMapsDialog, [{
			key: 'open',
			value: function open(cfg) {
				this._dialog.setOptions(cfg);

				this._dialog.open(this.map, cfg.marker);
			}
		}]);

		return GoogleMapsDialog;
	}(_metalState2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	GoogleMapsDialog.STATE = {
		/**
   * Map used for creating the dialog content
   * @review
   * @type {Object}
   */
		map: _metalState.Config.object()
	};

	exports.default = GoogleMapsDialog;
	exports.GoogleMapsDialog = GoogleMapsDialog;
	//# sourceMappingURL=GoogleMapsDialog.es.js.map
});
//# sourceMappingURL=GoogleMapsDialog.es.js.map