/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.map.google.maps.internal.display.context;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequest;

public class GoogleMapsDisplayContext {
    private String _configurationPrefix;
    private String _googleMapsAPIKey;
    private final HttpServletRequest _request;

    public GoogleMapsDisplayContext(HttpServletRequest request) {
        this._request = request;
    }

    public String getCompanyGoogleMapsAPIKey() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences((long)themeDisplay.getCompanyId());
        return companyPortletPreferences.getValue("googleMapsAPIKey", null);
    }

    public String getConfigurationPrefix() {
        if (Validator.isNull((String)this._configurationPrefix)) {
            this._configurationPrefix = GetterUtil.getString((Object)this._request.getAttribute("MAP_PROVIDER_CONFIGURATION_PREFIX"), (String)"TypeSettingsProperties");
        }
        return this._configurationPrefix;
    }

    public String getGoogleMapsAPIKey() {
        if (this._googleMapsAPIKey != null) {
            return this._googleMapsAPIKey;
        }
        Group group = this.getGroup();
        if (group == null) {
            this._googleMapsAPIKey = this.getCompanyGoogleMapsAPIKey();
            return this._googleMapsAPIKey;
        }
        this._googleMapsAPIKey = GetterUtil.getString((String)group.getTypeSettingsProperty("googleMapsAPIKey"), (String)this.getCompanyGoogleMapsAPIKey());
        return this._googleMapsAPIKey;
    }

    protected Group getGroup() {
        Group group = (Group)this._request.getAttribute("site.liveGroup");
        if (group != null) {
            return group;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        group = themeDisplay.getScopeGroup();
        if (!group.isControlPanel()) {
            return group;
        }
        return null;
    }
}

