'use strict';

Liferay.Loader.define('map-common@3.0.3/js/validators.es', ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.isSubsetOf = exports.isInputNode = undefined;

  var _metal = require('frontend-js-metal-web$metal');

  var _metal2 = _interopRequireDefault(_metal);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  /**
   * Checks if the given node is an instance of HTMLInputElement.
   * @param {*} node Node to be tested
   * @return {boolean}
   * @review
   */
  function isInputNode(node) {
    return node instanceof HTMLInputElement;
  }

  /**
   * Checks if the given set is a subset of the specified superset.
   * @param {Array[]} superset Group of valid elements.
   * @return {boolean}
   * @review
   */
  function isSubsetOf(superset) {
    return function (subset) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = subset[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var element = _step.value;

          if (superset.indexOf(element) === -1) {
            return false;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return true;
    };
  }

  exports.isInputNode = isInputNode;
  exports.isSubsetOf = isSubsetOf;
  //# sourceMappingURL=validators.es.js.map
});
//# sourceMappingURL=validators.es.js.map