'use strict';

Liferay.Loader.define("map-common@3.0.3/js/MarkerBase.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.MarkerBase = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalState2 = _interopRequireDefault(_metalState);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * MarkerBase
   * Each instance represents a marker being shown in the map.
   * The implemented abstract methods will allow adding markers
   * to the map instance and detecting click events on them.
   * @abstract
   * @review
   */
  var MarkerBase = function (_State) {
    _inherits(MarkerBase, _State);

    /**
     * Initializes the instance with a native marker which will handle all
     * the execution. This function may be moved to the class constructor in
     * the future, but currently it supports the legacy API.
     * @review
     */
    function MarkerBase() {
      var _ref;

      _classCallCheck(this, MarkerBase);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var _this = _possibleConstructorReturn(this, (_ref = MarkerBase.__proto__ || Object.getPrototypeOf(MarkerBase)).call.apply(_ref, [this].concat(args)));

      _this._nativeMarker = _this._getNativeMarker(_this.location, _this.map);
      return _this;
    }

    /**
     * Generates a function that, when fired, emits an event with a normalized
     * version of the received event and the given event type.
     * @param {string} externalEventType Event that will be emited when the
     * 	function is executed.
     * @return {function} Generated event handler.
     * @review
     */

    _createClass(MarkerBase, [{
      key: '_getNativeEventFunction',
      value: function _getNativeEventFunction(externalEventType) {
        var _this2 = this;

        var functionName = '_nativeEventHandler_' + externalEventType;

        this[functionName] = this[functionName] || function (nativeEvent) {
          _this2._handleNativeEvent(nativeEvent, externalEventType);
        };

        return this[functionName];
      }

      /**
       * Returns a nativeMarket object for a given location and map.
       * At this point any extra event should be added to the object, using
       * the implemented method _handleNativeEvent as handler.
       * @abstract
       * @param {Object} location
       * @param {Object} map
       * @return {Object} Generated native marker
       * @review
       */

    }, {
      key: '_getNativeMarker',
      value: function _getNativeMarker(location, map) {
        throw new Error('Must be implemented');
      }

      /**
       * For a given event, it returns a normalized version of it
       * with a common structure
       * @abstract
       * @param {Event} nativeEvent
       * @return {{ lat: number, lng: number }}
       * @review
       */

    }, {
      key: '_getNormalizedEventData',
      value: function _getNormalizedEventData(nativeEvent) {
        throw new Error('Must be implemented');
      }

      /**
       * Parses the given nativeEvent and emits a new event with the given
       * event type.
       * @param {Event} nativeEvent Native event that will be parsed.
       * @param {string} externalEventType Event type that will be emitted.
       * @review
       */

    }, {
      key: '_handleNativeEvent',
      value: function _handleNativeEvent(nativeEvent, externalEventType) {
        this.emit(externalEventType, this._getNormalizedEventData(nativeEvent));
      }
    }]);

    return MarkerBase;
  }(_metalState2.default);

  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  MarkerBase.STATE = {
    /**
     * Map to be used
     * @review
     * @type {Object}
     */
    map: _metalState.Config.object().value({}),

    /**
     * Location to be used
     * @review
     * @type {Object}
     */
    location: _metalState.Config.shapeOf({
      lat: _metalState.Config.number().required(),
      lng: _metalState.Config.number().required()
    }).value({ lat: 0, lng: 0 })
  };

  window.Liferay = window.Liferay || {};

  window.Liferay.MapMarkerBase = MarkerBase;

  exports.default = MarkerBase;
  exports.MarkerBase = MarkerBase;
  //# sourceMappingURL=MarkerBase.es.js.map
});
//# sourceMappingURL=MarkerBase.es.js.map