'use strict';

Liferay.Loader.define("map-common@3.0.3/js/MapBase.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-dom', './GeoJSONBase.es', './MarkerBase.es', './validators.es'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.MapBase = undefined;

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
		return typeof obj;
	} : function (obj) {
		return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	};

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _GeoJSONBase = require('./GeoJSONBase.es');

	var _GeoJSONBase2 = _interopRequireDefault(_GeoJSONBase);

	var _MarkerBase = require('./MarkerBase.es');

	var _MarkerBase2 = _interopRequireDefault(_MarkerBase);

	var _validators = require('./validators.es');

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * HTML template string used for generating the home button that is
  * used for centering the map at the user location or the original position.
  * @review
  * @type {string}
  */
	var TPL_HOME_BUTTON = '\n\t<button class=\'btn btn-default home-button\'>\n\t\t<i class=\'glyphicon glyphicon-screenshot\'></i>\n\t</button>\n';

	/**
  * HTML template string used for generating the search box that is used
  * for looking for map locations.
  * @review
  * @type {string}
  */
	var TPL_SEARCH_BOX = '\n\t<div class=\'col-md-6 search-controls\'>\n\t\t<input class=\'search-input\' placeholder=\'\' type=\'text\' />\n\t<div>\n';

	/**
  * Object that will hold callbacks waiting for being executed
  * when maps are created.
  * @review
  * @see MapBase.register()
  * @see MapBase.get()
  */
	var pendingCallbacks = {};

	/**
  * MapBase
  * Each instance represents the map object itself, and adds
  * all necesary listeners and object specified in the given
  * configuration. This class is the core of the module, and
  * will create instances of all the other objects, including
  * the native maps implemented by inheriting classes.
  * @abstract
  * @review
  */

	var MapBase = function (_State) {
		_inherits(MapBase, _State);

		/**
   * MapBase constructor
   * @param  {Array} args List of arguments to be sent to State constructor
   * @review
   */
		function MapBase() {
			var _ref;

			_classCallCheck(this, MapBase);

			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = MapBase.__proto__ || Object.getPrototypeOf(MapBase)).call.apply(_ref, [this].concat(args)));

			_this._customControls = {};
			_this._dialog = null;
			_this._eventHandlers = [];
			_this._geoJSONLayer = null;
			_this._geocoder = null;
			_this._geolocationMarker = null;
			_this._map = null;
			_this._originalPosition = null;

			_this._handleGeoJSONLayerFeatureClicked = _this._handleGeoJSONLayerFeatureClicked.bind(_this);
			_this._handleGeoJSONLayerFeaturesAdded = _this._handleGeoJSONLayerFeaturesAdded.bind(_this);
			_this._handleGeoLocationMarkerDragended = _this._handleGeoLocationMarkerDragended.bind(_this);
			_this._handleHomeButtonClicked = _this._handleHomeButtonClicked.bind(_this);
			_this._handlePositionChanged = _this._handlePositionChanged.bind(_this);
			_this._handleSearchButtonClicked = _this._handleSearchButtonClicked.bind(_this);

			_this.on('positionChange', _this._handlePositionChanged);

			var geolocation = _this.position && _this.position.location ? _this.position.location : {};

			if (!geolocation.lat || !geolocation.lng) {
				Liferay.Util.getGeolocation(function (lat, lng) {
					_this._initializeLocation({ lat: lat, lng: lng });
				});
			} else {
				_this._initializeLocation(geolocation);
			}
			return _this;
		}

		/**
   * Destroys the existing _geoJSONLayer and _customControls[SEARCH]
   * @review
   * @see MapBase._initializeMap()
   * @see MapBase._createCustomControls()
   */

		_createClass(MapBase, [{
			key: 'destructor',
			value: function destructor() {
				if (this._geoJSONLayer) {
					this._geoJSONLayer.dispose();

					this._geoJSONLayer = null;
				}

				if (this._customControls && this._customControls[this.constructor.CONTROLS.SEARCH]) {
					this._customControls[this.constructor.CONTROLS.SEARCH].dispose();

					this._customControls[this.constructor.CONTROLS.SEARCH] = null;
				}
			}

			/**
    * @protected
    * @review
    *
    * Add event listeners to:
    * @see this._geoJSONLayer
    * @see this._geolocationMarker
    * @see this._customControls
    *
    * All added listeners are implemented as binded methods:
    * @see this._handleGeoJSONLayerFeaturesAdded
    * @see this._handleGeoJSONLayerFeatureClicked
    * @see this._handleGeoLocationMarkerDragended
    * @see this._handleHomeButtonClicked
    * @see this._handleSearchButtonClicked
    */

		}, {
			key: '_bindUIMB',
			value: function _bindUIMB() {
				if (this._geoJSONLayer) {
					this._geoJSONLayer.on('featuresAdded', this._handleGeoJSONLayerFeaturesAdded);

					this._geoJSONLayer.on('featureClick', this._handleGeoJSONLayerFeatureClicked);
				}

				if (this._geolocationMarker) {
					this._geolocationMarker.on('dragend', this._handleGeoLocationMarkerDragended);
				}

				if (this._customControls) {
					var homeControl = this._customControls[this.constructor.CONTROLS.HOME];
					var searchControl = this._customControls[this.constructor.CONTROLS.SEARCH];

					if (homeControl) {
						homeControl.addEventListener('click', this._handleHomeButtonClicked);
					}

					if (searchControl) {
						searchControl.on('search', this._handleSearchButtonClicked);
					}
				}
			}

			/**
    * Creates existing custom controls and stores them inside _customControls.
    * It only adds the home button and the search box if the corresponding
    * flags are activated inside MapBase.controls.
    * @protected
    * @review
    */

		}, {
			key: '_createCustomControls',
			value: function _createCustomControls() {
				var controls = this.controls || [];
				var customControls = {};

				if (controls.indexOf(this.constructor.CONTROLS.HOME) !== -1) {
					var homeControl = (0, _metalDom.buildFragment)(TPL_HOME_BUTTON).firstElementChild;
					customControls[this.constructor.CONTROLS.HOME] = homeControl;
					this.addControl(homeControl, this.constructor.POSITION.RIGHT_BOTTOM);
				}

				if (controls.indexOf(this.constructor.CONTROLS.SEARCH) !== -1 && this.constructor.SearchImpl) {
					var searchControl = (0, _metalDom.buildFragment)(TPL_SEARCH_BOX).firstElementChild;
					customControls[this.constructor.CONTROLS.SEARCH] = new this.constructor.SearchImpl({
						inputNode: searchControl.querySelector('input')
					});
					this.addControl(searchControl, this.constructor.POSITION.TOP_LEFT);
				}

				this._customControls = customControls;
			}

			/**
    * Creates a new map for the given location and controlsConfig.
    * @abstract
    * @param {Object} location
    * @param {Object} controlsConfig
    * @protected
    * @return {Object} Created map
    * @review
    */

		}, {
			key: '_createMap',
			value: function _createMap(geolocation, controlsConfig) {
				throw new Error('This method must be implemented');
			}

			/**
    * Returns an object with the control configuration associated to the
    * existing controls (MapBase.controls).
    * @protected
    * @return {Object} Object with the control options with the following shape:
    *  for each control, there is a corresponding [control] attribute with a
    *  boolean value indicating if there is a configuration for the control. If
    *  true, where will be a [control]Options attribute with the configuration
    *  content.
    * @review
    */

		}, {
			key: '_getControlsConfig',
			value: function _getControlsConfig() {
				var _this2 = this;

				var config = {};
				var availableControls = this.controls.map(function (item) {
					return typeof item === 'string' ? item : item.name;
				});

				Object.keys(this.constructor.CONTROLS_MAP).forEach(function (key) {
					var controlIndex = availableControls.indexOf(key);
					var value = _this2.constructor.CONTROLS_MAP[key];

					if (controlIndex > -1) {
						var controlConfig = _this2.controls[controlIndex];

						if (controlConfig && (typeof controlConfig === 'undefined' ? 'undefined' : _typeof(controlConfig)) === 'object' && controlConfig.cfg) {
							config[value + 'Options'] = controlConfig.cfg;
						}

						config[value] = controlIndex !== -1;
					}
				});

				return config;
			}

			/**
    * If there is an existing this._dialog, it returns it.
    * Otherwise, if the MapBase.DialogImpl class has been set, it creates
    * a new instance with the existing map and returns it.
    * @protected
    * @return {MapBase.DialogImpl|null}
    * @review
    */

		}, {
			key: '_getDialog',
			value: function _getDialog() {
				if (!this._dialog && this.constructor.DialogImpl) {
					this._dialog = new this.constructor.DialogImpl({
						map: this._map
					});
				}

				return this._dialog;
			}

			/**
    * If there is an existing this._geocoder, it returns it.
    * Otherwise, if the MapBase.GeocoderImpl class has been set, it creates
    * a new instance and returns it.
    * @protected
    * @return {MapBase.GeocoderImpl|null}
    * @review
    */

		}, {
			key: '_getGeocoder',
			value: function _getGeocoder() {
				if (!this._geocoder && this.constructor.GeocoderImpl) {
					this._geocoder = new this.constructor.GeocoderImpl();
				}

				return this._geocoder;
			}

			/**
    * Event handler executed when any feature is added to the existing.
    * GeoJSONLayer. It will update the current position if necesary.
    * @param {{ features: Array<Object> }} param0 Array of features that
    *  will be processed.
    * @protected
    * @review
    * @see MapBase.getBounds()
    * @see MapBase.position
    */

		}, {
			key: '_handleGeoJSONLayerFeaturesAdded',
			value: function _handleGeoJSONLayerFeaturesAdded(_ref2) {
				var features = _ref2.features;

				var bounds = this.getBounds();

				var locations = features.map(function (feature) {
					return feature.getGeometry().get();
				});

				if (locations.length > 1) {
					locations.forEach(function (location) {
						return bounds.extend(location);
					});
				} else {
					this.position = { location: locations[0] };
				}
			}

			/**
    * Event handler executed when a GeoJSONLayer feature is clicked. It
    * simple propagates the event with the given feature.
    * @param {{ feature: Object }} param0 Feature to be propagated.
    * @protected
    * @review
    */

		}, {
			key: '_handleGeoJSONLayerFeatureClicked',
			value: function _handleGeoJSONLayerFeatureClicked(_ref3) {
				var feature = _ref3.feature;

				this.emit('featureClick', { feature: feature });
			}

			/**
    * Event handler executed when the geolocation marker has been dragged to
    * a new position. It updates the instance position.
    * @param {{ location: Object }} param0 New marker location.
    * @protected
    * @review
    * @see MapBase._getGeoCoder()
    * @see MapBase.position
    */

		}, {
			key: '_handleGeoLocationMarkerDragended',
			value: function _handleGeoLocationMarkerDragended(_ref4) {
				var _this3 = this;

				var location = _ref4.location;

				this._getGeocoder().reverse(location, function (_ref5) {
					var data = _ref5.data;

					_this3.position = data;
				});
			}

			/**
    * Event handler executed when the home button GeoJSONLayer feature is
    * clicked. It resets the instance position to _originalPosition and stops
    * the event propagation.
    * @param {Event} event Click event.
    * @review
    * @see MapBase.position
    * @see MapBase._originalPosition
    */

		}, {
			key: '_handleHomeButtonClicked',
			value: function _handleHomeButtonClicked(event) {
				event.preventDefault();

				this.position = this._originalPosition;
			}

			/**
    * Event handler executed when the user position changes. It centers the map
    * and, if existing, updates the _geolocationMarker position.
    * @param {{ newVal: { location: Object } }} param0 New location information.
    * @review
    * @see MapBase.setCenter()
    * @see MapBase._geolocationMarker
    */

		}, {
			key: '_handlePositionChanged',
			value: function _handlePositionChanged(_ref6) {
				var location = _ref6.newVal.location;

				this.setCenter(location);

				if (this._geolocationMarker) {
					this._geolocationMarker.setPosition(location);
				}
			}

			/**
    * Event handler executed when the search button GeoJSONLayer feature has
    * been clicked. It updates the instance position.
    * @param {{ position: Object }} param0 New position.
    * @review
    * @see MapBase.position
    */

		}, {
			key: '_handleSearchButtonClicked',
			value: function _handleSearchButtonClicked(_ref7) {
				var position = _ref7.position;

				this.position = position;
			}

			/**
    * If this.data has a truthy value and this._geoJSONLayer has been
    * set, it tries to parse geoJSON information with _geoJSONLayer.addData()
    * @protected
    * @review
    * @see this._geoJSONLayer
    * @see this.data
    */

		}, {
			key: '_initializeGeoJSONData',
			value: function _initializeGeoJSONData() {
				if (this.data && this._geoJSONLayer) {
					this._geoJSONLayer.addData(this.data);
				}
			}

			/**
    * Initializes the instance map using the given location and, if
    * this.geolocation property is true, tries to get the location using
    * the geocoder.
    * @param {Object} location Location object user for map initialization.
    * @protected
    * @review
    * @see this._initializeMap()
    * @see this._getGeocoder()
    */

		}, {
			key: '_initializeLocation',
			value: function _initializeLocation(geolocation) {
				var _this4 = this;

				var geocoder = this._getGeocoder();

				if (this.geolocation && geocoder) {
					geocoder.reverse(geolocation, function (_ref8) {
						var data = _ref8.data;
						return _this4._initializeMap(data);
					});
				} else {
					this._initializeMap({ location: geolocation });
				}
			}

			/**
    * Creates a new map with the given position and initialize the map
    * controls, loads the geoJSONData and, if geolocation is active, creates
    * a marker for it.
    * @param {Object} position Initial position added to the map.
    * @protected
    * @review
    * @see MapBase._getControlsConfig()
    * @see MapBase._createMap()
    * @see MapBase.GeoJSONImpl
    * @see MapBase.addMarker()
    * @see MapBase._createCustomControls()
    * @see MapBase._bindUIMB()
    * @see MapBase._initializeGeoJSONData()
    */

		}, {
			key: '_initializeMap',
			value: function _initializeMap(position) {
				var controlsConfig = this._getControlsConfig();
				var geolocation = position.location;

				this._originalPosition = position;
				this._map = this._createMap(geolocation, controlsConfig);

				if (this.constructor.GeoJSONImpl && this.constructor.GeoJSONImpl !== _GeoJSONBase2.default) {
					this._geoJSONLayer = new this.constructor.GeoJSONImpl({
						map: this._map
					});
				}

				if (this.geolocation) {
					this._geolocationMarker = this.addMarker(geolocation);
				}

				this.position = position;

				this._createCustomControls();
				this._bindUIMB();
				this._initializeGeoJSONData();
			}

			/**
    * Adds a new control to the interface at the given position.
    * @param {Object} control Native control object
    * @param {MapBase.POSITION} position Position defined in MapBase class
    * @review
    */

		}, {
			key: 'addControl',
			value: function addControl() /* control, position */{
				throw new Error('This method must be implemented');
			}

			/**
    * Returns the map bounds.
    * @abstract
    * @return {Object} Map bounds
    * @review
    */

		}, {
			key: 'getBounds',
			value: function getBounds() {
				throw new Error('This method must be implemented');
			}

			/**
    * Centers the map on the given location.
    * @abstract
    * @param {Object} location
    * @review
    */

		}, {
			key: 'setCenter',
			value: function setCenter() /* location */{
				throw new Error('This method must be implemented');
			}

			/**
    * If the class MapBase.MarkerImpl has been specified, creates an instance
    * of this class with the given location and the existing this._map object
    * and returns it.
    * @param {Object} location Location object used for the marker position
    * @return {MapBase.MarkerImpl}
    * @review
    */

		}, {
			key: 'addMarker',
			value: function addMarker(location) {
				var marker = void 0;

				if (this.constructor.MarkerImpl && this.constructor.MarkerImpl !== _MarkerBase2.default) {
					marker = new this.constructor.MarkerImpl({
						location: location,
						map: this._map
					});
				}

				return marker;
			}

			/**
    * Returns the stored map
    * @return {Object}
    * @review
    * @see MapBase._initializeMap()
    */

		}, {
			key: 'getNativeMap',
			value: function getNativeMap() {
				return this._map;
			}

			/**
    * Adds a listener for the given event using the given context. This
    * methods uses MetalJS' functionality, but overrides the context binding
    * in order to avoid breaking changes with the old implementation.
    * @param {string} eventName Event name that will be listened.
    * @param {function} callback Callback executed when the event fires.
    * @param {Object} [context] Optional context that will be used for binding
    *  the callback when specified.
    * @return {*} Result of the State.on method.
    * @review
    * @see State.on
    */

		}, {
			key: 'on',
			value: function on(eventName, callback, context) {
				var boundCallback = callback;

				if (context) {
					boundCallback = callback.bind(context);
				}

				return _get(MapBase.prototype.__proto__ || Object.getPrototypeOf(MapBase.prototype), 'on', this).call(this, eventName, boundCallback);
			}

			/**
    * Opens a dialog if this_getDialog() returns a valid object.
    * @param {*} dialogConfig Dialog configuration that will be sent to the
    *  dialog.open() method.
    * @review
    * @see MapBase._getDialog()
    */

		}, {
			key: 'openDialog',
			value: function openDialog(dialogConfig) {
				var dialog = this._getDialog();

				if (dialog) {
					dialog.open(dialogConfig);
				}
			}

			/**
    * Setter called everytime the position attribute is changed.
    * @param {Object} position New position
    * @return {Object} The given position object
    * @review
    */

		}, {
			key: 'setPosition',
			value: function setPosition(position) {
				this.emit('positionChange', {
					newVal: {
						location: position.location,
						address: position.address
					}
				});

				return position;
			}
		}]);

		return MapBase;
	}(_metalState2.default);

	/**
  * Registers the given callback to be executed when the map identified
  * by the given id has been created. If the map has already been created, it
  * is executed immediatly.
  * @param {string} id Id of the map that needs to be created
  * @param {function} callback Callback being executed
  * @review
  */

	MapBase.get = function (id, callback) {
		var map = Liferay.component(id);

		if (map) {
			callback(map);
		} else {
			var idPendingCallbacks = pendingCallbacks[id] || [];

			idPendingCallbacks.push(callback);

			pendingCallbacks[id] = idPendingCallbacks;
		}
	};

	/**
  * Registers the given map with the given id, and executes all existing
  * callbacks associated with the id. Then it clears the list of callbacks.
  * @param {string} id Id of the map that has been created
  * @param {Object} map Map that has been created
  * @param {string} portletId Id of the portlet that registers the map
  * @review
  */
	MapBase.register = function (id, map, portletId) {
		var destroyConfig = portletId ? { portletId: portletId } : { destroyOnNavigate: true };

		Liferay.component(id, map, destroyConfig);

		var idPendingCallbacks = pendingCallbacks[id];

		if (idPendingCallbacks) {
			idPendingCallbacks.forEach(function (callback) {
				return callback(map);
			});

			idPendingCallbacks.length = 0;
		}
	};

	/**
  * Class that will be used for creating dialog objects.
  * @review
  */
	MapBase.DialogImpl = null;

	/**
  * Class that will be used for parsing geoposition information.
  * @review
  */
	MapBase.GeocoderImpl = null;

	/**
  * Class that will be used for creating GeoJSON instances.
  * This class must be replaced by another one extending GeoJSONBase.
  * @review
  */
	MapBase.GeoJSONImpl = _GeoJSONBase2.default;

	/**
  * Class that will be used for creating map markers.
  * This class must be replaced by another one extending MarkerBase.
  * @review
  */
	MapBase.MarkerImpl = _MarkerBase2.default;

	/**
  * Class that will be used for creating an instance of searchbox.
  * This class must be replaced by another one extending MarkerBase.
  * @review
  */
	MapBase.SearchImpl = null;

	/**
  * List of controls that maybe shown inside the rendered map.
  * @review
  */
	MapBase.CONTROLS = {
		ATTRIBUTION: 'attribution',
		GEOLOCATION: 'geolocation',
		HOME: 'home',
		OVERVIEW: 'overview',
		PAN: 'pan',
		ROTATE: 'rotate',
		SCALE: 'scale',
		SEARCH: 'search',
		STREETVIEW: 'streetview',
		TYPE: 'type',
		ZOOM: 'zoom'
	};

	/**
  * Control mapping that should be overriden by child classes.
  * @review
  */
	MapBase.CONTROLS_MAP = {};

	/**
  * Available map positions.
  * @review
  */
	MapBase.POSITION = {
		BOTTOM: 11,
		BOTTOM_CENTER: 11,
		BOTTOM_LEFT: 10,
		BOTTOM_RIGHT: 12,
		CENTER: 13,
		LEFT: 5,
		LEFT_BOTTOM: 6,
		LEFT_CENTER: 4,
		LEFT_TOP: 5,
		RIGHT: 7,
		RIGHT_BOTTOM: 9,
		RIGHT_CENTER: 8,
		RIGHT_TOP: 7,
		TOP: 2,
		TOP_CENTER: 2,
		TOP_LEFT: 1,
		TOP_RIGHT: 3
	};

	/**
  * Position mapping that should be overriden by child classes.
  * @review
  */
	MapBase.POSITION_MAP = {};

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */
	MapBase.STATE = {
		/**
   * DOM node selector identifying the element that will be used
   * for rendering the map
   * @review
   * @type {string}
   */
		boundingBox: _metalState.Config.string().value(''),

		/**
   * List of controls that will be shown on the map.
   * The full control list is kept inside MapBase.CONTROLS.
   * @review
   * @type {Array<string>}
   */
		controls: _metalState.Config.validator((0, _validators.isSubsetOf)(Object.values(MapBase.CONTROLS))).value([MapBase.CONTROLS.PAN, MapBase.CONTROLS.TYPE, MapBase.CONTROLS.ZOOM]),

		/**
   * Data that will be parsed as GeoJSONData
   * @review
   * @type {Object}
   */
		data: _metalState.Config.object(),

		/**
   * If true, the geolocation API will be used (if implemented)
   * @review
   * @type {boolean}
   */
		geolocation: _metalState.Config.bool().value(false),

		/**
   * Position being shown on the map. This value will be updated
   * if the position is changed internally.
   * @review
   * @type {{ lat: number, lng: number }}
   */
		position: _metalState.Config.shapeOf({
			location: _metalState.Config.shapeOf({
				lat: _metalState.Config.number().value(0),
				lng: _metalState.Config.number().value(0)
			})
		}).value({
			location: { lat: 0, lng: 0 }
		}).setter('setPosition'),

		/**
   * Zoom being used on the map.
   * @review
   * @type {number}
   */
		zoom: _metalState.Config.number().value(11)
	};

	Liferay.MapBase = MapBase;

	exports.default = MapBase;
	exports.MapBase = MapBase;
	//# sourceMappingURL=MapBase.es.js.map
});
//# sourceMappingURL=MapBase.es.js.map