'use strict';

Liferay.Loader.define("map-common@3.0.3/js/GeoJSONBase.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.GeoJSONBase = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalState2 = _interopRequireDefault(_metalState);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * GeoJSONBase
   * Allows adding controls (called features) to the map, that produce
   * diverse actions. For example, a button for centering the map
   * view will act as a feature.
   * @abstract
   * @review
   */
  var GeoJSONBase = function (_State) {
    _inherits(GeoJSONBase, _State);

    function GeoJSONBase() {
      _classCallCheck(this, GeoJSONBase);

      return _possibleConstructorReturn(this, (GeoJSONBase.__proto__ || Object.getPrototypeOf(GeoJSONBase)).apply(this, arguments));
    }

    _createClass(GeoJSONBase, [{
      key: 'addData',

      /**
       * Receives an object with native features data and tries
       * to parse it with the implemented method _getNativeFeatures.
       * If the generated Array of native features is not empty, it fires
       * a 'featuresAdded' event.
       * @param {Object} nativeFeaturesData Data to be processed.
       * @review
       */
      value: function addData(nativeFeaturesData) {
        var nativeFeatures = this._getNativeFeatures(nativeFeaturesData);

        if (nativeFeatures.length > 0) {
          this.emit('featuresAdded', {
            features: nativeFeatures.map(this._wrapNativeFeature)
          });
        }
      }

      /**
       * Callback executed when a native feature has been clicked.
       * It receives the feature as parameter, and emits a 'featureClick'
       * event with the wrapped feature as event data.
       * @param {Object} nativeFeature Feature to be wrapped and sent
       * @protected
       * @review
       */

    }, {
      key: '_handleFeatureClicked',
      value: function _handleFeatureClicked(nativeFeature) {
        this.emit('featureClick', {
          feature: this._wrapNativeFeature(nativeFeature)
        });
      }

      /**
       * Parses a nativeFeaturesData object and return an array of the
       * parsed features. If no feature has been parsed it may return an
       * empty array.
       * @abstract
       * @param {Object} nativeFeaturesData
       * @protected
       * @return {Object[]} List of native features to be added
       * @review
       */

    }, {
      key: '_getNativeFeatures',
      value: function _getNativeFeatures(nativeFeaturesData) {
        throw new Error('Must be implemented');
      }

      /**
       * Wraps a native feature.
       * @abstract
       * @param {Object} nativeFeature
       * @protected
       * @return {Object} Wrapped native feature
       * @review
       */

    }, {
      key: '_wrapNativeFeature',
      value: function _wrapNativeFeature(nativeFeature) {
        throw new Error('Must be implemented');
      }
    }]);

    return GeoJSONBase;
  }(_metalState2.default);

  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  GeoJSONBase.STATE = {
    /**
     * Map to be used
     * @review
     * @type {Object}
     */
    map: _metalState.Config.object()
  };

  window.Liferay = window.Liferay || {};

  window.Liferay.MapGeojsonBase = GeoJSONBase;

  exports.default = GeoJSONBase;
  exports.GeoJSONBase = GeoJSONBase;
  //# sourceMappingURL=GeoJSONBase.es.js.map
});
//# sourceMappingURL=GeoJSONBase.es.js.map