/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.map;

import com.liferay.map.MapProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseJSPMapProvider
implements MapProvider {
    private static final Log _log = LogFactoryUtil.getLog(BaseJSPMapProvider.class);
    private ServletContext _servletContext;

    public abstract String getConfigurationJspPath();

    public abstract String getJspPath();

    @Override
    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return this.includeJSP(httpServletRequest, httpServletResponse, this.getJspPath());
    }

    @Override
    public boolean includeConfiguration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return this.includeJSP(httpServletRequest, httpServletResponse, this.getConfigurationJspPath());
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected boolean includeJSP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String jspPath) throws IOException {
        if (Validator.isNull((String)jspPath)) {
            return false;
        }
        RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher(jspPath);
        this.prepareRequest(httpServletRequest);
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (ServletException servletException) {
            _log.error((Object)("Unable to include " + jspPath), (Throwable)servletException);
            return false;
        }
        return true;
    }

    protected abstract void prepareRequest(HttpServletRequest var1);
}

