/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.openid.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.openid.OpenId;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.OpenIdServiceException;
import com.liferay.portal.security.sso.openid.OpenIdServiceHandler;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/openid"}, service={MVCActionCommand.class})
public class OpenIdLoginMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(OpenIdLoginMVCActionCommand.class);
    private OpenId _openId;
    private OpenIdServiceHandler _openIdServiceHandler;
    @Reference
    private Portal _portal;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!this._openId.isEnabled(themeDisplay.getCompanyId())) {
            throw new PrincipalException.MustBeEnabled(themeDisplay.getCompanyId(), new String[]{OpenId.class.getName()});
        }
        if (actionRequest.getRemoteUser() != null) {
            actionResponse.sendRedirect(themeDisplay.getPathMain());
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("read")) {
                String redirect = this._openIdServiceHandler.readResponse(themeDisplay, actionRequest);
                if (Validator.isNull((String)redirect)) {
                    redirect = themeDisplay.getURLSignIn();
                }
                redirect = this._portal.escapeRedirect(redirect);
                actionResponse.sendRedirect(redirect);
            } else {
                this._openIdServiceHandler.sendRequest(themeDisplay, actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof OpenIdServiceException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Error communicating with OpenID provider: " + e.getMessage()));
                }
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof UserEmailAddressException.MustNotBeDuplicate) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            _log.error((Object)"Error processing the OpenID login", (Throwable)e);
            this._portal.sendError(e, actionRequest, actionResponse);
        }
    }

    @Reference(unbind="-")
    protected void setOpenId(OpenId openId) {
        this._openId = openId;
    }

    @Reference(unbind="-")
    protected void setOpenIdServiceHandler(OpenIdServiceHandler openIdServiceHandler) {
        this._openIdServiceHandler = openIdServiceHandler;
    }
}

